/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.threads.BoundedQueueThreadPoolAdd;
import org.jboss.as.threads.BoundedQueueThreadPoolService;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadsMessages;
import org.jboss.as.threads.ThreadsWriteAttributeOperationHandler;
import org.jboss.as.threads.TimeSpec;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class BoundedQueueThreadPoolWriteAttributeHandler
extends ThreadsWriteAttributeOperationHandler {
    private final ServiceName serviceNameBase;

    public BoundedQueueThreadPoolWriteAttributeHandler(boolean blocking, ServiceName serviceNameBase) {
        super(blocking ? BoundedQueueThreadPoolAdd.BLOCKING_ATTRIBUTES : BoundedQueueThreadPoolAdd.NON_BLOCKING_ATTRIBUTES, BoundedQueueThreadPoolAdd.RW_ATTRIBUTES);
        this.serviceNameBase = serviceNameBase;
    }

    @Override
    protected void applyOperation(OperationContext context, ModelNode model, String attributeName, ServiceController<?> service, boolean forRollback) throws OperationFailedException {
        BoundedQueueThreadPoolService pool = (BoundedQueueThreadPoolService)service.getService();
        if (PoolAttributeDefinitions.KEEPALIVE_TIME.getName().equals(attributeName)) {
            TimeUnit defaultUnit = pool.getKeepAliveUnit();
            TimeSpec spec = BoundedQueueThreadPoolWriteAttributeHandler.getTimeSpec(context, model, defaultUnit);
            pool.setKeepAlive(spec);
        } else if (PoolAttributeDefinitions.MAX_THREADS.getName().equals(attributeName)) {
            pool.setMaxThreads(PoolAttributeDefinitions.MAX_THREADS.resolveModelAttribute(context, model).asInt());
        } else if (PoolAttributeDefinitions.CORE_THREADS.getName().equals(attributeName)) {
            ModelNode coreNode = PoolAttributeDefinitions.CORE_THREADS.resolveModelAttribute(context, model);
            int coreCount = coreNode.isDefined() ? coreNode.asInt() : PoolAttributeDefinitions.MAX_THREADS.resolveModelAttribute(context, model).asInt();
            pool.setCoreThreads(coreCount);
        } else if (PoolAttributeDefinitions.QUEUE_LENGTH.getName().equals(attributeName)) {
            if (forRollback) {
                context.revertReloadRequired();
            } else {
                context.reloadRequired();
            }
        } else if (PoolAttributeDefinitions.ALLOW_CORE_TIMEOUT.getName().equals(attributeName)) {
            pool.setAllowCoreTimeout(PoolAttributeDefinitions.ALLOW_CORE_TIMEOUT.resolveModelAttribute(context, model).asBoolean());
        } else if (!forRollback) {
            throw ThreadsMessages.MESSAGES.unsupportedBoundedQueueThreadPoolAttribute(attributeName);
        }
    }

    @Override
    protected ServiceController<?> getService(OperationContext context, ModelNode model) throws OperationFailedException {
        String name = Util.getNameFromAddress((ModelNode)model.require("address"));
        ServiceName serviceName = this.serviceNameBase.append(new String[]{name});
        ServiceController controller = context.getServiceRegistry(true).getService(serviceName);
        if (controller == null) {
            throw ThreadsMessages.MESSAGES.boundedQueueThreadPoolServiceNotFound(serviceName);
        }
        return controller;
    }
}

