/*
 * Decompiled with CFR 0.152.
 */
package org.apache.noggit;

import org.apache.noggit.CharArr;
import org.apache.noggit.JSONUtil;
import org.apache.noggit.TextWriter;

public class JSONWriter
extends TextWriter {
    int level;
    boolean doIndent;
    final CharArr out;

    JSONWriter(CharArr out) {
        this.out = out;
    }

    @Override
    public void writeNull() {
        JSONUtil.writeNull(this.out);
    }

    @Override
    public void writeString(CharSequence str) {
        JSONUtil.writeString(str, 0, str.length(), this.out);
    }

    @Override
    public void writeString(CharArr str) {
        JSONUtil.writeString(str, this.out);
    }

    @Override
    public void writeStringStart() {
        this.out.write('\"');
    }

    @Override
    public void writeStringChars(CharArr partialStr) {
        JSONUtil.writeStringPart(partialStr.getArray(), partialStr.getStart(), partialStr.getEnd(), this.out);
    }

    @Override
    public void writeStringEnd() {
        this.out.write('\"');
    }

    @Override
    public void write(long number) {
        JSONUtil.writeNumber(number, this.out);
    }

    @Override
    public void write(double number) {
        JSONUtil.writeNumber(number, this.out);
    }

    @Override
    public void write(boolean bool) {
        JSONUtil.writeBoolean(bool, this.out);
    }

    @Override
    public void writeNumber(CharArr digits) {
        this.out.write(digits);
    }

    @Override
    public void writePartialNumber(CharArr digits) {
        this.out.write(digits);
    }

    @Override
    public void startObject() {
        this.out.write('{');
        ++this.level;
    }

    @Override
    public void endObject() {
        this.out.write('}');
        --this.level;
    }

    @Override
    public void startArray() {
        this.out.write('[');
        ++this.level;
    }

    @Override
    public void endArray() {
        this.out.write(']');
        --this.level;
    }

    @Override
    public void writeValueSeparator() {
        this.out.write(',');
    }

    @Override
    public void writeNameSeparator() {
        this.out.write(':');
    }
}

