/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.Constants;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.JBossXBValueFormatException;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.metadata.PackageMetaData;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SimpleTypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.jboss.xb.binding.sunday.xop.XOPMarshaller;
import org.jboss.xb.binding.sunday.xop.XOPUnmarshaller;
import org.jboss.xb.util.DomCharactersHandler;
import org.jboss.xb.util.DomLocalMarshaller;
import org.jboss.xb.util.DomParticleHandler;

public class SchemaBinding {
    private static final ValueAdapter DATE_ADAPTER = new ValueAdapter(){

        @Override
        public Object cast(Object o, Class<?> c) {
            if (c != null && o != null && Date.class.isAssignableFrom(c)) {
                o = ((Calendar)o).getTime();
            }
            return o;
        }
    };
    private Set<String> namespaces = Collections.emptySet();
    private Map<String, String> nsByPrefix = Collections.emptyMap();
    private Map<QName, TypeBinding> types = new HashMap<QName, TypeBinding>();
    private Map<QName, ParticleBinding> elements = new HashMap<QName, ParticleBinding>();
    private Map<QName, ModelGroupBinding> groups = new HashMap<QName, ModelGroupBinding>();
    private PackageMetaData packageMetaData;
    private SchemaBindingResolver schemaResolver;
    private boolean strictSchema = true;
    private boolean ignoreUnresolvedFieldOrClass = true;
    private boolean ignoreLowLine = true;
    private boolean replacePropertyRefs = true;
    private boolean unmarshalListsToArrays;
    private boolean useNoArgCtorIfFound;
    private String simpleContentProperty = "value";
    private boolean ignoreWhitespacesInMixedContent = true;
    private boolean normalizeSpace;
    private XOPUnmarshaller xopUnmarshaller;
    private XOPMarshaller xopMarshaller;

    public SchemaBinding() {
        this.addType(new SimpleTypeBinding(Constants.QNAME_ANYSIMPLETYPE, CharactersHandler.NOOP_UNMARSHAL_HANDLER));
        this.addType(new SimpleTypeBinding(Constants.QNAME_STRING, CharactersHandler.NOOP_UNMARSHAL_HANDLER));
        this.addType(new SimpleTypeBinding(Constants.QNAME_BOOLEAN, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                if (value.length() == 1) {
                    char c = value.charAt(0);
                    if (c == '1') {
                        return Boolean.TRUE;
                    }
                    if (c == '0') {
                        return Boolean.FALSE;
                    }
                    throw new JBossXBValueFormatException("An instance of a datatype that is defined as ?boolean? can have the following legal literals {true, false, 1, 0}. But got: " + value);
                }
                return Boolean.valueOf(value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_DECIMAL, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                return new BigDecimal(value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_FLOAT, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                if ("INF".equals(value)) {
                    return new Float(Float.POSITIVE_INFINITY);
                }
                if ("-INF".equals(value)) {
                    return new Float(Float.NEGATIVE_INFINITY);
                }
                return Float.valueOf(value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_DOUBLE, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                if ("INF".equals(value)) {
                    return new Double(Double.POSITIVE_INFINITY);
                }
                if ("-INF".equals(value)) {
                    return new Double(Double.NEGATIVE_INFINITY);
                }
                return Double.valueOf(value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_DURATION, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                throw new IllegalStateException("Recognized but not supported xsdType: " + Constants.QNAME_DURATION);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_DATETIME, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                return SimpleTypeBindings.unmarshalDateTime(value);
            }
        }, DATE_ADAPTER));
        this.addType(new SimpleTypeBinding(Constants.QNAME_TIME, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                return SimpleTypeBindings.unmarshalTime(value);
            }
        }, DATE_ADAPTER));
        this.addType(new SimpleTypeBinding(Constants.QNAME_DATE, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                return SimpleTypeBindings.unmarshalDate(value);
            }
        }, DATE_ADAPTER));
        this.addType(new SimpleTypeBinding(Constants.QNAME_GYEARMONTH, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                return SimpleTypeBindings.unmarshalGYearMonth(value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_GYEAR, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                return SimpleTypeBindings.unmarshalGYear(value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_GMONTHDAY, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                return SimpleTypeBindings.unmarshalGMonthDay(value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_GDAY, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                return SimpleTypeBindings.unmarshalGDay(value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_GMONTH, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                return SimpleTypeBindings.unmarshalGMonth(value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_HEXBINARY, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                return SimpleTypeBindings.unmarshalHexBinary(value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_BASE64BINARY, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                return SimpleTypeBindings.unmarshalBase64(value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_ANYURI, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                try {
                    return new URI(value);
                }
                catch (URISyntaxException e) {
                    throw new JBossXBValueFormatException("Failed to unmarshal anyURI value " + value, e);
                }
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_QNAME, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                return SimpleTypeBindings.unmarshalQName(value, nsCtx);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_NOTATION, CharactersHandler.NOOP));
        this.addType(new SimpleTypeBinding(Constants.QNAME_NORMALIZEDSTRING, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                if (SimpleTypeBindings.isNormalizedString(value)) {
                    return value;
                }
                throw new JBossXBValueFormatException("Invalid normalizedString value: " + value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_TOKEN, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                if (SimpleTypeBindings.isValidToken(value)) {
                    return value;
                }
                throw new JBossXBValueFormatException("Invalid token value: " + value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_LANGUAGE, CharactersHandler.NOOP));
        this.addType(new SimpleTypeBinding(Constants.QNAME_NMTOKEN, CharactersHandler.NOOP));
        this.addType(new SimpleTypeBinding(Constants.QNAME_NMTOKENS, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                return SimpleTypeBindings.unmarshalNMTokens(value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_NAME, CharactersHandler.NOOP));
        this.addType(new SimpleTypeBinding(Constants.QNAME_NCNAME, CharactersHandler.NOOP));
        this.addType(new SimpleTypeBinding(Constants.QNAME_ID, CharactersHandler.NOOP));
        this.addType(new SimpleTypeBinding(Constants.QNAME_IDREF, CharactersHandler.NOOP));
        this.addType(new SimpleTypeBinding(Constants.QNAME_IDREFS, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                return SimpleTypeBindings.unmarshalIdRefs(value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_ENTITY, CharactersHandler.NOOP));
        this.addType(new SimpleTypeBinding(Constants.QNAME_ENTITIES, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                return SimpleTypeBindings.unmarshalIdRefs(value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_INTEGER, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                return new BigInteger(value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_NONPOSITIVEINTEGER, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                BigInteger result = new BigInteger(value);
                if (BigInteger.ZERO.compareTo(result) < 0) {
                    throw new JBossXBValueFormatException("Invalid nonPositiveInteger value: " + value);
                }
                return result;
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_NEGATIVEINTEGER, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                BigInteger result = new BigInteger(value);
                if (BigInteger.ZERO.compareTo(result) <= 0) {
                    throw new JBossXBValueFormatException("Invalid negativeInteger value: " + value);
                }
                return result;
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_LONG, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                return Long.valueOf(value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_INT, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                return Integer.valueOf(value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_SHORT, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                return Short.valueOf(value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_BYTE, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                return Byte.valueOf(value);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_NONNEGATIVEINTEGER, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                BigInteger result = new BigInteger(value);
                if (BigInteger.ZERO.compareTo(result) > 0) {
                    throw new JBossXBValueFormatException("Invalid nonNegativeInteger value: " + value);
                }
                return result;
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_UNSIGNEDLONG, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                BigInteger d = new BigInteger(value);
                if (d.doubleValue() < 0.0 || d.doubleValue() > 1.8446744073709552E19) {
                    throw new JBossXBValueFormatException("Invalid unsignedLong value: " + value);
                }
                return d;
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_UNSIGNEDINT, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                long l = Long.parseLong(value);
                if (l < 0L || l > 0xFFFFFFFFL) {
                    throw new JBossXBValueFormatException("Invalid unsignedInt value: " + value);
                }
                return new Long(l);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_UNSIGNEDSHORT, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                int i = Integer.parseInt(value);
                if (i < 0 || i > 65535) {
                    throw new JBossXBValueFormatException("Invalid unsignedShort value: " + value);
                }
                return new Integer(i);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_UNSIGNEDBYTE, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                short s = Short.parseShort(value);
                if (s < 0 || s > 255) {
                    throw new JBossXBValueFormatException("Invalid unsignedByte value: " + value);
                }
                return new Short(s);
            }
        }));
        this.addType(new SimpleTypeBinding(Constants.QNAME_POSITIVEINTEGER, new CharactersHandler.UnmarshalCharactersHandler(){

            @Override
            public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Value string cannot be null");
                }
                BigInteger result = new BigInteger(value);
                if (BigInteger.ZERO.compareTo(result) >= 0) {
                    throw new JBossXBValueFormatException("Invalid positiveInteger value: " + value);
                }
                return result;
            }
        }));
    }

    public void addPrefixMapping(String prefix, String ns) {
        if (this.nsByPrefix.isEmpty()) {
            this.nsByPrefix = Collections.singletonMap(prefix, ns);
        } else {
            if (this.nsByPrefix.size() == 1) {
                this.nsByPrefix = new HashMap<String, String>(this.nsByPrefix);
            }
            this.nsByPrefix.put(prefix, ns);
        }
    }

    public String getNamespace(String prefix) {
        return this.nsByPrefix.get(prefix);
    }

    public Set<String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Set<String> namespaces) {
        if (namespaces == null) {
            throw new IllegalArgumentException("Null namespaces");
        }
        this.namespaces = namespaces;
    }

    public TypeBinding getType(QName qName) {
        return this.types.get(qName);
    }

    public void addType(TypeBinding type) {
        QName qName = type.getQName();
        if (qName == null) {
            throw new JBossXBRuntimeException("Global type must have a name.");
        }
        this.types.put(qName, type);
    }

    public ElementBinding getElement(QName name) {
        ParticleBinding particle = this.elements.get(name);
        ElementBinding element = (ElementBinding)(particle == null ? null : particle.getTerm());
        return element;
    }

    public ParticleBinding getElementParticle(QName name) {
        return this.elements.get(name);
    }

    public void addElement(ElementBinding element) {
        ParticleBinding particle = new ParticleBinding(element);
        this.elements.put(element.getQName(), particle);
    }

    public ElementBinding addElement(QName name, TypeBinding type) {
        ElementBinding element = new ElementBinding(this, name, type);
        this.addElement(element);
        return element;
    }

    public Iterator<ElementBinding> getElements() {
        return new Iterator<ElementBinding>(){
            private Iterator<ParticleBinding> particleIterator;
            {
                this.particleIterator = SchemaBinding.this.elements.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.particleIterator.hasNext();
            }

            @Override
            public ElementBinding next() {
                ParticleBinding particle = this.particleIterator.next();
                return (ElementBinding)particle.getTerm();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not implemented.");
            }
        };
    }

    public Iterator<ParticleBinding> getElementParticles() {
        return this.elements.values().iterator();
    }

    public Iterator<TypeBinding> getTypes() {
        return Collections.unmodifiableCollection(this.types.values()).iterator();
    }

    public ModelGroupBinding getGroup(QName name) {
        return this.groups.get(name);
    }

    public void addGroup(QName name, ModelGroupBinding group) {
        this.groups.put(name, group);
    }

    public Iterator<ModelGroupBinding> getGroups() {
        return this.groups.values().iterator();
    }

    public PackageMetaData getPackageMetaData() {
        return this.packageMetaData;
    }

    public void setPackageMetaData(PackageMetaData packageMetaData) {
        this.packageMetaData = packageMetaData;
    }

    public SchemaBindingResolver getSchemaResolver() {
        return this.schemaResolver;
    }

    public void setSchemaResolver(SchemaBindingResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
    }

    public boolean isStrictSchema() {
        return this.strictSchema;
    }

    public void setStrictSchema(boolean strictSchema) {
        this.strictSchema = strictSchema;
    }

    public boolean isIgnoreUnresolvedFieldOrClass() {
        return this.ignoreUnresolvedFieldOrClass;
    }

    public void setIgnoreUnresolvedFieldOrClass(boolean ignoreUnresolvedFieldOrClass) {
        this.ignoreUnresolvedFieldOrClass = ignoreUnresolvedFieldOrClass;
    }

    public boolean isReplacePropertyRefs() {
        return this.replacePropertyRefs;
    }

    public void setReplacePropertyRefs(boolean flag) {
        this.replacePropertyRefs = flag;
    }

    public boolean isIgnoreLowLine() {
        return this.ignoreLowLine;
    }

    public void setIgnoreLowLine(boolean ignoreLowLine) {
        this.ignoreLowLine = ignoreLowLine;
    }

    public boolean isUnmarshalListsToArrays() {
        return this.unmarshalListsToArrays;
    }

    public void setUnmarshalListsToArrays(boolean unmarshalListsToArrays) {
        this.unmarshalListsToArrays = unmarshalListsToArrays;
    }

    public boolean isUseNoArgCtorIfFound() {
        return this.useNoArgCtorIfFound;
    }

    public void setUseNoArgCtorIfFound(boolean useNoArgCtorIfFound) {
        this.useNoArgCtorIfFound = useNoArgCtorIfFound;
    }

    public String getSimpleContentProperty() {
        return this.simpleContentProperty;
    }

    public void setSimpleContentProperty(String simpleContentProperty) {
        this.simpleContentProperty = simpleContentProperty;
    }

    public XOPUnmarshaller getXopUnmarshaller() {
        return this.xopUnmarshaller;
    }

    public void setXopUnmarshaller(XOPUnmarshaller xopUnmarshaller) {
        this.xopUnmarshaller = xopUnmarshaller;
    }

    public XOPMarshaller getXopMarshaller() {
        return this.xopMarshaller;
    }

    public void setXopMarshaller(XOPMarshaller xopMarshaller) {
        this.xopMarshaller = xopMarshaller;
    }

    public void setUnresolvedContentBoundToDOM(boolean toDom) {
        TypeBinding type = this.getType(Constants.QNAME_ANYTYPE);
        if (type == null) {
            return;
        }
        WildcardBinding wildcard = type.getWildcard();
        if (toDom) {
            wildcard.setUnresolvedCharactersHandler(DomCharactersHandler.INSTANCE);
            wildcard.setUnresolvedElementHandler(DomParticleHandler.INSTANCE);
            wildcard.setUnresolvedMarshaller(DomLocalMarshaller.INSTANCE);
        } else {
            wildcard.setUnresolvedCharactersHandler(null);
            wildcard.setUnresolvedElementHandler(null);
            wildcard.setUnresolvedMarshaller(null);
        }
    }

    public boolean isUnresolvedContentBoundToDOM() {
        TypeBinding type = this.getType(Constants.QNAME_ANYTYPE);
        if (type == null) {
            return false;
        }
        WildcardBinding wildcard = type.getWildcard();
        return wildcard.getUnresolvedCharactersHandler() instanceof DomCharactersHandler && wildcard.getUnresolvedElementHandler() instanceof DomParticleHandler && wildcard.getUnresolvedMarshaller() instanceof DomLocalMarshaller;
    }

    public boolean isIgnoreWhitespacesInMixedContent() {
        return this.ignoreWhitespacesInMixedContent;
    }

    public void setIgnoreWhitespacesInMixedContent(boolean value) {
        this.ignoreWhitespacesInMixedContent = value;
    }

    public boolean isNormalizeSpace() {
        return this.normalizeSpace;
    }

    public void setNormalizeSpace(boolean value) {
        this.normalizeSpace = value;
    }

    void addElementParticle(ParticleBinding particle) {
        ElementBinding element = (ElementBinding)particle.getTerm();
        this.elements.put(element.getQName(), particle);
    }
}

