/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.util.Arrays;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;

public class ClassFilePool {
    public static final int POOL_SIZE = 25;
    ClassFile[] classFiles = new ClassFile[25];

    private ClassFilePool() {
    }

    public static ClassFilePool newInstance() {
        return new ClassFilePool();
    }

    public synchronized ClassFile acquire(SourceTypeBinding typeBinding) {
        for (int i = 0; i < 25; ++i) {
            ClassFile classFile = this.classFiles[i];
            if (classFile == null) {
                ClassFile newClassFile;
                this.classFiles[i] = newClassFile = new ClassFile(typeBinding);
                newClassFile.isShared = true;
                return newClassFile;
            }
            if (classFile.isShared) continue;
            classFile.reset(typeBinding);
            classFile.isShared = true;
            return classFile;
        }
        return new ClassFile(typeBinding);
    }

    public synchronized void release(ClassFile classFile) {
        classFile.isShared = false;
    }

    public void reset() {
        Arrays.fill(this.classFiles, null);
    }
}

