/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.index.DocFieldConsumer;
import org.apache.lucene.index.DocFieldConsumerPerField;
import org.apache.lucene.index.DocFieldConsumerPerThread;
import org.apache.lucene.index.DocFieldProcessorPerThread;
import org.apache.lucene.index.DocInverterPerField;
import org.apache.lucene.index.DocInverterPerThread;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.InvertedDocConsumer;
import org.apache.lucene.index.InvertedDocConsumerPerField;
import org.apache.lucene.index.InvertedDocConsumerPerThread;
import org.apache.lucene.index.InvertedDocEndConsumer;
import org.apache.lucene.index.InvertedDocEndConsumerPerField;
import org.apache.lucene.index.InvertedDocEndConsumerPerThread;
import org.apache.lucene.index.SegmentWriteState;

final class DocInverter
extends DocFieldConsumer {
    final InvertedDocConsumer consumer;
    final InvertedDocEndConsumer endConsumer;

    public DocInverter(InvertedDocConsumer consumer, InvertedDocEndConsumer endConsumer) {
        this.consumer = consumer;
        this.endConsumer = endConsumer;
    }

    @Override
    void setFieldInfos(FieldInfos fieldInfos) {
        super.setFieldInfos(fieldInfos);
        this.consumer.setFieldInfos(fieldInfos);
        this.endConsumer.setFieldInfos(fieldInfos);
    }

    @Override
    void flush(Map<DocFieldConsumerPerThread, Collection<DocFieldConsumerPerField>> threadsAndFields, SegmentWriteState state) throws IOException {
        HashMap<InvertedDocConsumerPerThread, Collection<InvertedDocConsumerPerField>> childThreadsAndFields = new HashMap<InvertedDocConsumerPerThread, Collection<InvertedDocConsumerPerField>>();
        HashMap<InvertedDocEndConsumerPerThread, Collection<InvertedDocEndConsumerPerField>> endChildThreadsAndFields = new HashMap<InvertedDocEndConsumerPerThread, Collection<InvertedDocEndConsumerPerField>>();
        for (Map.Entry<DocFieldConsumerPerThread, Collection<DocFieldConsumerPerField>> entry : threadsAndFields.entrySet()) {
            DocInverterPerThread perThread = (DocInverterPerThread)entry.getKey();
            HashSet<InvertedDocConsumerPerField> childFields = new HashSet<InvertedDocConsumerPerField>();
            HashSet<InvertedDocEndConsumerPerField> endChildFields = new HashSet<InvertedDocEndConsumerPerField>();
            for (DocFieldConsumerPerField field : entry.getValue()) {
                DocInverterPerField perField = (DocInverterPerField)field;
                childFields.add(perField.consumer);
                endChildFields.add(perField.endConsumer);
            }
            childThreadsAndFields.put(perThread.consumer, childFields);
            endChildThreadsAndFields.put(perThread.endConsumer, endChildFields);
        }
        this.consumer.flush(childThreadsAndFields, state);
        this.endConsumer.flush(endChildThreadsAndFields, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void abort() {
        try {
            this.consumer.abort();
        }
        finally {
            this.endConsumer.abort();
        }
    }

    @Override
    public boolean freeRAM() {
        return this.consumer.freeRAM();
    }

    @Override
    public DocFieldConsumerPerThread addThread(DocFieldProcessorPerThread docFieldProcessorPerThread) {
        return new DocInverterPerThread(docFieldProcessorPerThread, this);
    }
}

