/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.model;

import java.util.List;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.config.FileStoreConfigurationBuilder;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoreConfigurationBuilder;
import org.picketlink.idm.config.LDAPMappingConfigurationBuilder;
import org.picketlink.idm.config.LDAPStoreConfigurationBuilder;
import org.picketlink.idm.config.NamedIdentityConfigurationBuilder;
import org.picketlink.idm.model.Relationship;
import org.wildfly.extension.picketlink.PicketLinkMessages;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.idm.config.JPAStoreSubsystemConfiguration;
import org.wildfly.extension.picketlink.idm.config.JPAStoreSubsystemConfigurationBuilder;
import org.wildfly.extension.picketlink.idm.model.AttributedTypeEnum;
import org.wildfly.extension.picketlink.idm.model.CredentialHandlerResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.CredentialTypeEnum;
import org.wildfly.extension.picketlink.idm.model.FileStoreResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.JPAStoreResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.LDAPStoreAttributeResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.LDAPStoreMappingResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.LDAPStoreResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.PartitionManagerResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.SupportedTypeResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.SupportedTypesResourceDefinition;
import org.wildfly.extension.picketlink.idm.service.FileIdentityStoreService;
import org.wildfly.extension.picketlink.idm.service.JPAIdentityStoreService;
import org.wildfly.extension.picketlink.idm.service.PartitionManagerService;

public class PartitionManagerAddHandler
extends AbstractAddStepHandler {
    static final PartitionManagerAddHandler INSTANCE = new PartitionManagerAddHandler();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition attribute : PartitionManagerResourceDefinition.INSTANCE.getAttributes()) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String federationName = address.getLastElement().getValue();
        ModelNode partitionManager = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        this.createPartitionManagerService(context, federationName, partitionManager, verificationHandler, newControllers, false);
    }

    public void validateModel(OperationContext context, String partitionManagerName, ModelNode partitionManager) throws OperationFailedException {
        this.createPartitionManagerService(context, partitionManagerName, partitionManager, null, null, true);
    }

    public void createPartitionManagerService(OperationContext context, String partitionManagerName, ModelNode partitionManager, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, boolean onlyValidate) throws OperationFailedException {
        ModelNode identityConfigurationNode;
        String jndiName = PartitionManagerResourceDefinition.IDENTITY_MANAGEMENT_JNDI_URL.resolveModelAttribute(context, partitionManager).asString();
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        PartitionManagerService partitionManagerService = new PartitionManagerService(partitionManagerName, jndiName, builder);
        ServiceBuilder serviceBuilder = null;
        if (!onlyValidate) {
            serviceBuilder = context.getServiceTarget().addService(PartitionManagerService.createServiceName(partitionManagerName), (Service)partitionManagerService);
        }
        if (!(identityConfigurationNode = partitionManager.get(ModelElement.IDENTITY_CONFIGURATION.getName())).isDefined()) {
            throw PicketLinkMessages.MESSAGES.idmNoIdentityConfigurationProvided();
        }
        for (Property identityConfiguration : identityConfigurationNode.asPropertyList()) {
            String configurationName = identityConfiguration.getName();
            NamedIdentityConfigurationBuilder namedIdentityConfigurationBuilder = builder.named(configurationName);
            if (!identityConfiguration.getValue().isDefined()) {
                throw PicketLinkMessages.MESSAGES.idmNoIdentityStoreProvided(configurationName);
            }
            List identityStores = identityConfiguration.getValue().asList();
            for (ModelNode store : identityStores) {
                this.configureIdentityStore(context, (ServiceBuilder<PartitionManager>)serviceBuilder, verificationHandler, newControllers, partitionManagerService, configurationName, namedIdentityConfigurationBuilder, store);
            }
        }
        if (!onlyValidate) {
            if (verificationHandler != null) {
                serviceBuilder.addListener((ServiceListener)verificationHandler);
            }
            ServiceController controller = serviceBuilder.setInitialMode(ServiceController.Mode.PASSIVE).install();
            if (newControllers != null) {
                newControllers.add(controller);
            }
        }
    }

    private void configureIdentityStore(OperationContext context, ServiceBuilder<PartitionManager> serviceBuilder, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, PartitionManagerService partitionManagerService, String configurationName, NamedIdentityConfigurationBuilder namedIdentityConfigurationBuilder, ModelNode modelNode) throws OperationFailedException {
        Property prop = modelNode.asProperty();
        String storeType = prop.getName();
        ModelNode identityStore = prop.getValue().asProperty().getValue();
        JPAStoreSubsystemConfigurationBuilder storeConfig = null;
        if (storeType.equals(ModelElement.JPA_STORE.getName())) {
            storeConfig = this.configureJPAIdentityStore(context, serviceBuilder, verificationHandler, newControllers, partitionManagerService, identityStore, configurationName, namedIdentityConfigurationBuilder);
        } else if (storeType.equals(ModelElement.FILE_STORE.getName())) {
            storeConfig = this.configureFileIdentityStore(context, serviceBuilder, verificationHandler, newControllers, partitionManagerService, identityStore, configurationName, namedIdentityConfigurationBuilder);
        } else if (storeType.equals(ModelElement.LDAP_STORE.getName())) {
            storeConfig = this.configureLDAPIdentityStore(context, identityStore, namedIdentityConfigurationBuilder);
        }
        ModelNode supportAttributeNode = JPAStoreResourceDefinition.SUPPORT_ATTRIBUTE.resolveModelAttribute(context, identityStore);
        storeConfig.supportAttributes(supportAttributeNode.asBoolean());
        ModelNode supportCredentialNode = JPAStoreResourceDefinition.SUPPORT_CREDENTIAL.resolveModelAttribute(context, identityStore);
        storeConfig.supportCredentials(supportCredentialNode.asBoolean());
        this.configureSupportedTypes(context, identityStore, (IdentityStoreConfigurationBuilder)storeConfig);
        this.configureCredentialHandlers(context, identityStore, (IdentityStoreConfigurationBuilder)storeConfig);
    }

    private LDAPStoreConfigurationBuilder configureLDAPIdentityStore(OperationContext context, ModelNode ldapIdentityStore, NamedIdentityConfigurationBuilder builder) throws OperationFailedException {
        LDAPStoreConfigurationBuilder storeConfig = builder.stores().ldap();
        ModelNode url = LDAPStoreResourceDefinition.URL.resolveModelAttribute(context, ldapIdentityStore);
        ModelNode bindDn = LDAPStoreResourceDefinition.BIND_DN.resolveModelAttribute(context, ldapIdentityStore);
        ModelNode bindCredential = LDAPStoreResourceDefinition.BIND_CREDENTIAL.resolveModelAttribute(context, ldapIdentityStore);
        ModelNode baseDn = LDAPStoreResourceDefinition.BASE_DN_SUFFIX.resolveModelAttribute(context, ldapIdentityStore);
        ModelNode uniqueIdAttributeName = LDAPStoreResourceDefinition.UNIQUE_ID_ATTRIBUTE_NAME.resolveModelAttribute(context, ldapIdentityStore);
        ModelNode activeDirectory = LDAPStoreResourceDefinition.ACTIVE_DIRECTORY.resolveModelAttribute(context, ldapIdentityStore);
        if (url.isDefined()) {
            storeConfig.url(url.asString());
        }
        if (bindDn.isDefined()) {
            storeConfig.bindDN(bindDn.asString());
        }
        if (bindCredential.isDefined()) {
            storeConfig.bindCredential(bindCredential.asString());
        }
        if (baseDn.isDefined()) {
            storeConfig.baseDN(baseDn.asString());
        }
        if (uniqueIdAttributeName.isDefined()) {
            storeConfig.uniqueIdentifierAttributeName(uniqueIdAttributeName.asString());
        }
        storeConfig.activeDirectory(activeDirectory.asBoolean());
        if (ldapIdentityStore.hasDefined(ModelElement.LDAP_STORE_MAPPING.getName())) {
            for (Property mappingNode : ldapIdentityStore.get(ModelElement.LDAP_STORE_MAPPING.getName()).asPropertyList()) {
                String typeName;
                ModelNode ldapMapping = mappingNode.getValue();
                ModelNode classNameNode = LDAPStoreMappingResourceDefinition.CLASS_NAME.resolveModelAttribute(context, ldapMapping);
                ModelNode codeNode = LDAPStoreMappingResourceDefinition.CODE.resolveModelAttribute(context, ldapMapping);
                ModelNode moduleNode = LDAPStoreMappingResourceDefinition.MODULE.resolveModelAttribute(context, ldapMapping);
                if (classNameNode.isDefined()) {
                    typeName = classNameNode.asString();
                } else if (codeNode.isDefined()) {
                    typeName = AttributedTypeEnum.forType(codeNode.asString());
                } else {
                    throw PicketLinkMessages.MESSAGES.typeNotProvided(ModelElement.LDAP_STORE_MAPPING.getName());
                }
                LDAPMappingConfigurationBuilder storeMapping = storeConfig.mapping(this.loadClass(moduleNode, typeName));
                ModelNode relatesToNode = LDAPStoreMappingResourceDefinition.RELATES_TO.resolveModelAttribute(context, ldapMapping);
                if (relatesToNode.isDefined()) {
                    String relatesTo = AttributedTypeEnum.forType(relatesToNode.asString());
                    if (relatesTo == null) {
                        relatesTo = relatesToNode.asString();
                    }
                    storeMapping.forMapping(this.loadClass(moduleNode, relatesTo));
                } else {
                    String baseDN = LDAPStoreMappingResourceDefinition.BASE_DN.resolveModelAttribute(context, ldapMapping).asString();
                    storeMapping.baseDN(baseDN);
                    String objectClasses = LDAPStoreMappingResourceDefinition.OBJECT_CLASSES.resolveModelAttribute(context, ldapMapping).asString();
                    for (String objClass : objectClasses.split(",")) {
                        if (objClass.trim().isEmpty()) continue;
                        storeMapping.objectClasses(new String[]{objClass});
                    }
                    ModelNode parentAttributeName = LDAPStoreMappingResourceDefinition.PARENT_ATTRIBUTE.resolveModelAttribute(context, ldapMapping);
                    if (parentAttributeName.isDefined()) {
                        storeMapping.parentMembershipAttributeName(parentAttributeName.asString());
                    }
                }
                if (!ldapMapping.hasDefined(ModelElement.LDAP_STORE_ATTRIBUTE.getName())) continue;
                for (Property attributeNode : ldapMapping.get(ModelElement.LDAP_STORE_ATTRIBUTE.getName()).asPropertyList()) {
                    ModelNode attribute = attributeNode.getValue();
                    String name = LDAPStoreAttributeResourceDefinition.NAME.resolveModelAttribute(context, attribute).asString();
                    String ldapName = LDAPStoreAttributeResourceDefinition.LDAP_NAME.resolveModelAttribute(context, attribute).asString();
                    boolean readOnly = LDAPStoreAttributeResourceDefinition.READ_ONLY.resolveModelAttribute(context, attribute).asBoolean();
                    if (readOnly) {
                        storeMapping.readOnlyAttribute(name, ldapName);
                        continue;
                    }
                    boolean isIdentifier = LDAPStoreAttributeResourceDefinition.IS_IDENTIFIER.resolveModelAttribute(context, attribute).asBoolean();
                    storeMapping.attribute(name, ldapName, isIdentifier);
                }
            }
        } else {
            throw PicketLinkMessages.MESSAGES.idmLdapNoMappingDefined();
        }
        return storeConfig;
    }

    private IdentityStoreConfigurationBuilder configureFileIdentityStore(OperationContext context, ServiceBuilder<PartitionManager> serviceBuilder, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, PartitionManagerService partitionManagerService, ModelNode resource, String configurationName, NamedIdentityConfigurationBuilder builder) throws OperationFailedException {
        FileStoreConfigurationBuilder fileStoreBuilder = builder.stores().file();
        String workingDir = FileStoreResourceDefinition.WORKING_DIR.resolveModelAttribute(context, resource).asString();
        String relativeTo = FileStoreResourceDefinition.RELATIVE_TO.resolveModelAttribute(context, resource).asString();
        ModelNode alwaysCreateFiles = FileStoreResourceDefinition.ALWAYS_CREATE_FILE.resolveModelAttribute(context, resource);
        ModelNode asyncWrite = FileStoreResourceDefinition.ASYNC_WRITE.resolveModelAttribute(context, resource);
        ModelNode asyncWriteThreadPool = FileStoreResourceDefinition.ASYNC_WRITE_THREAD_POOL.resolveModelAttribute(context, resource);
        fileStoreBuilder.preserveState(!alwaysCreateFiles.asBoolean());
        fileStoreBuilder.asyncWrite(asyncWrite.asBoolean());
        fileStoreBuilder.asyncWriteThreadPool(asyncWriteThreadPool.asInt());
        if (serviceBuilder != null) {
            FileIdentityStoreService storeService = new FileIdentityStoreService(fileStoreBuilder, workingDir, relativeTo);
            ServiceName storeServiceName = PartitionManagerService.createIdentityStoreServiceName(partitionManagerService.getName(), configurationName, ModelElement.FILE_STORE.getName());
            ServiceBuilder storeServiceBuilder = context.getServiceTarget().addService(storeServiceName, (Service)storeService);
            storeServiceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, storeService.getPathManager());
            serviceBuilder.addDependency(storeServiceName);
            if (verificationHandler != null) {
                storeServiceBuilder.addListener((ServiceListener)verificationHandler);
            }
            ServiceController controller = storeServiceBuilder.setInitialMode(ServiceController.Mode.PASSIVE).install();
            if (newControllers != null) {
                newControllers.add(controller);
            }
        }
        return fileStoreBuilder;
    }

    private JPAStoreSubsystemConfigurationBuilder configureJPAIdentityStore(OperationContext context, ServiceBuilder<PartitionManager> serviceBuilder, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, PartitionManagerService partitionManagerService, ModelNode identityStore, String configurationName, NamedIdentityConfigurationBuilder builder) throws OperationFailedException {
        JPAStoreSubsystemConfigurationBuilder storeConfig = (JPAStoreSubsystemConfigurationBuilder)builder.stores().add(JPAStoreSubsystemConfiguration.class, JPAStoreSubsystemConfigurationBuilder.class);
        ModelNode jpaDataSourceNode = JPAStoreResourceDefinition.DATA_SOURCE.resolveModelAttribute(context, identityStore);
        ModelNode jpaEntityModule = JPAStoreResourceDefinition.ENTITY_MODULE.resolveModelAttribute(context, identityStore);
        ModelNode jpaEntityModuleUnitName = JPAStoreResourceDefinition.ENTITY_MODULE_UNIT_NAME.resolveModelAttribute(context, identityStore);
        ModelNode jpaEntityManagerFactoryNode = JPAStoreResourceDefinition.ENTITY_MANAGER_FACTORY.resolveModelAttribute(context, identityStore);
        if (jpaEntityModule.isDefined()) {
            storeConfig.entityModule(jpaEntityModule.asString());
        }
        storeConfig.entityModuleUnitName(jpaEntityModuleUnitName.asString());
        if (serviceBuilder != null) {
            JPAIdentityStoreService storeService = new JPAIdentityStoreService(storeConfig);
            ServiceName storeServiceName = PartitionManagerService.createIdentityStoreServiceName(partitionManagerService.getName(), configurationName, ModelElement.JPA_STORE.getName());
            ServiceBuilder storeServiceBuilder = context.getServiceTarget().addService(storeServiceName, (Service)storeService);
            storeServiceBuilder.addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, storeService.getTransactionManager());
            storeServiceBuilder.addDependency(TxnServices.JBOSS_TXN_SYNCHRONIZATION_REGISTRY, TransactionSynchronizationRegistry.class, storeService.getTransactionSynchronizationRegistry());
            if (jpaDataSourceNode.isDefined()) {
                storeConfig.dataSourceJndiUrl(this.toJndiName(jpaDataSourceNode.asString()));
                storeServiceBuilder.addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(this.toJndiName(jpaDataSourceNode.asString()).split("/")));
            }
            if (jpaEntityManagerFactoryNode.isDefined()) {
                storeConfig.entityManagerFactoryJndiName(jpaEntityManagerFactoryNode.asString());
                storeServiceBuilder.addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(jpaEntityManagerFactoryNode.asString().split("/")), ValueManagedReferenceFactory.class, (Injector)new InjectedValue());
            }
            serviceBuilder.addDependency(storeServiceName);
            if (verificationHandler != null) {
                storeServiceBuilder.addListener((ServiceListener)verificationHandler);
            }
            ServiceController controller = storeServiceBuilder.setInitialMode(ServiceController.Mode.PASSIVE).install();
            if (newControllers != null) {
                newControllers.add(controller);
            }
        }
        return storeConfig;
    }

    private void configureSupportedTypes(OperationContext context, ModelNode identityStore, IdentityStoreConfigurationBuilder storeConfig) throws OperationFailedException {
        boolean hasSupportedType = identityStore.hasDefined(ModelElement.SUPPORTED_TYPES.getName());
        if (hasSupportedType) {
            ModelNode featuresSetNode = identityStore.get(ModelElement.SUPPORTED_TYPES.getName()).asProperty().getValue();
            ModelNode supportsAllNode = SupportedTypesResourceDefinition.SUPPORTS_ALL.resolveModelAttribute(context, featuresSetNode);
            if (supportsAllNode.asBoolean()) {
                storeConfig.supportAllFeatures();
            }
            hasSupportedType = supportsAllNode.asBoolean();
            if (featuresSetNode.hasDefined(ModelElement.SUPPORTED_TYPE.getName())) {
                for (Property supportedTypeNode : featuresSetNode.get(ModelElement.SUPPORTED_TYPE.getName()).asPropertyList()) {
                    String typeName;
                    ModelNode supportedType = supportedTypeNode.getValue();
                    ModelNode classNameNode = SupportedTypeResourceDefinition.CLASS_NAME.resolveModelAttribute(context, supportedType);
                    ModelNode codeNode = SupportedTypeResourceDefinition.CODE.resolveModelAttribute(context, supportedType);
                    if (classNameNode.isDefined()) {
                        typeName = classNameNode.asString();
                    } else if (codeNode.isDefined()) {
                        typeName = AttributedTypeEnum.forType(codeNode.asString());
                    } else {
                        throw PicketLinkMessages.MESSAGES.typeNotProvided(ModelElement.SUPPORTED_TYPE.getName());
                    }
                    ModelNode moduleNode = SupportedTypeResourceDefinition.MODULE.resolveModelAttribute(context, supportedType);
                    Class attributedTypeClass = this.loadClass(moduleNode, typeName);
                    if (Relationship.class.isAssignableFrom(attributedTypeClass)) {
                        storeConfig.supportGlobalRelationship(new Class[]{attributedTypeClass});
                    } else {
                        storeConfig.supportType(new Class[]{attributedTypeClass});
                    }
                    hasSupportedType = true;
                }
            }
        }
        if (!hasSupportedType) {
            throw PicketLinkMessages.MESSAGES.idmNoSupportedTypesDefined();
        }
    }

    private void configureCredentialHandlers(OperationContext context, ModelNode identityStore, IdentityStoreConfigurationBuilder storeConfig) throws OperationFailedException {
        if (identityStore.hasDefined(ModelElement.IDENTITY_STORE_CREDENTIAL_HANDLER.getName())) {
            for (Property credentialHandler : identityStore.get(ModelElement.IDENTITY_STORE_CREDENTIAL_HANDLER.getName()).asPropertyList()) {
                String typeName;
                ModelNode classNameNode = CredentialHandlerResourceDefinition.CLASS_NAME.resolveModelAttribute(context, credentialHandler.getValue());
                ModelNode codeNode = CredentialHandlerResourceDefinition.CODE.resolveModelAttribute(context, credentialHandler.getValue());
                ModelNode moduleNode = CredentialHandlerResourceDefinition.MODULE.resolveModelAttribute(context, credentialHandler.getValue());
                if (classNameNode.isDefined()) {
                    typeName = classNameNode.asString();
                } else if (codeNode.isDefined()) {
                    typeName = CredentialTypeEnum.forType(codeNode.asString());
                } else {
                    throw PicketLinkMessages.MESSAGES.typeNotProvided(ModelElement.IDENTITY_STORE_CREDENTIAL_HANDLER.getName());
                }
                storeConfig.addCredentialHandler(this.loadClass(moduleNode, typeName));
            }
        }
    }

    private String toJndiName(String jndiName) {
        if (jndiName != null && jndiName.startsWith("java:")) {
            return jndiName.substring(jndiName.indexOf(":") + 1);
        }
        return jndiName;
    }

    private Module getModule(ModelNode moduleNode) {
        Module module;
        if (moduleNode.isDefined()) {
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            try {
                module = moduleLoader.loadModule(ModuleIdentifier.create((String)moduleNode.asString()));
            }
            catch (ModuleLoadException e) {
                throw PicketLinkMessages.MESSAGES.moduleCouldNotLoad(moduleNode.asString(), e);
            }
        } else {
            module = Module.getCallerModule();
        }
        return module;
    }

    private <T> Class<T> loadClass(ModelNode moduleNode, String typeName) {
        try {
            Module module = this.getModule(moduleNode);
            if (module != null) {
                return module.getClassLoader().loadClass(typeName);
            }
            return ((Object)((Object)this)).getClass().getClassLoader().loadClass(typeName);
        }
        catch (ClassNotFoundException cnfe) {
            throw PicketLinkMessages.MESSAGES.couldNotLoadClass(typeName, cnfe);
        }
    }
}

