/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Session;
import org.jboss.as.mail.extension.Credentials;
import org.jboss.as.mail.extension.CustomServerConfig;
import org.jboss.as.mail.extension.MailLogger;
import org.jboss.as.mail.extension.MailMessages;
import org.jboss.as.mail.extension.MailSessionConfig;
import org.jboss.as.mail.extension.ServerConfig;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.MapInjector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class MailSessionService
implements Service<Session> {
    private volatile Properties props;
    private final MailSessionConfig config;
    private Map<String, OutboundSocketBinding> socketBindings = new HashMap<String, OutboundSocketBinding>();

    public MailSessionService(MailSessionConfig config) {
        MailLogger.ROOT_LOGGER.tracef("service constructed with config: %s", config);
        this.config = config;
    }

    public MailSessionConfig getConfig() {
        return this.config;
    }

    public void start(StartContext startContext) throws StartException {
        MailLogger.ROOT_LOGGER.trace("start...");
        this.props = this.getProperties();
    }

    public void stop(StopContext stopContext) {
        MailLogger.ROOT_LOGGER.trace("stop...");
    }

    Injector<OutboundSocketBinding> getSocketBindingInjector(String name) {
        return new MapInjector(this.socketBindings, (Object)name);
    }

    private Properties getProperties() throws StartException {
        Properties props = new Properties();
        if (this.config.getSmtpServer() != null) {
            props.setProperty("mail.transport.protocol", "smtp");
            this.setServerProps(props, this.config.getSmtpServer(), "smtp");
        }
        if (this.config.getImapServer() != null) {
            props.setProperty("mail.store.protocol", "imap");
            this.setServerProps(props, this.config.getImapServer(), "imap");
        }
        if (this.config.getPop3Server() != null) {
            props.setProperty("mail.store.protocol", "pop3");
            this.setServerProps(props, this.config.getPop3Server(), "pop3");
        }
        if (this.config.getCustomServers() != null) {
            this.configureCustomServers(props, this.config.getCustomServers());
        }
        if (this.config.getFrom() != null) {
            props.setProperty("mail.from", this.config.getFrom());
        }
        props.setProperty("mail.debug", String.valueOf(this.config.isDebug()));
        MailLogger.ROOT_LOGGER.tracef("props: %s", props);
        return props;
    }

    private void configureCustomServers(Properties props, CustomServerConfig ... serverConfigs) throws StartException {
        for (CustomServerConfig config : serverConfigs) {
            this.setServerProps(props, config, config.getProtocol());
        }
    }

    private void setServerProps(Properties props, ServerConfig server, String protocol) throws StartException {
        if (server.isSslEnabled()) {
            props.setProperty(MailSessionService.getPropKey(protocol, "ssl.enable"), "true");
        } else if (server.isTlsEnabled()) {
            props.setProperty(MailSessionService.getPropKey(protocol, "starttls.enable"), "true");
        }
        if (server.getCredentials() != null) {
            props.setProperty(MailSessionService.getPropKey(protocol, "auth"), "true");
            props.setProperty(MailSessionService.getPropKey(protocol, "user"), server.getCredentials().getUsername());
        }
        props.setProperty(MailSessionService.getPropKey(protocol, "debug"), String.valueOf(this.config.isDebug()));
        Map<String, String> customProps = server.getProperties();
        if (server.getOutgoingSocketBinding() != null) {
            InetSocketAddress socketAddress = this.getServerSocketAddress(server);
            props.setProperty(MailSessionService.getHostKey(protocol), NetworkUtils.canonize((String)socketAddress.getAddress().getHostName()));
            props.setProperty(MailSessionService.getPortKey(protocol), String.valueOf(socketAddress.getPort()));
        } else {
            String port;
            String host = customProps.get("host");
            if (host != null && !"".equals(host.trim())) {
                props.setProperty(MailSessionService.getHostKey(protocol), host);
            }
            if ((port = customProps.get("port")) != null && !"".equals(port.trim())) {
                props.setProperty(MailSessionService.getPortKey(protocol), port);
            }
        }
        if (customProps != null && !customProps.isEmpty()) {
            for (Map.Entry<String, String> prop : customProps.entrySet()) {
                if (props.contains(prop.getKey())) continue;
                if (prop.getKey().contains(".")) {
                    props.put(prop.getKey(), prop.getValue());
                    continue;
                }
                props.put(MailSessionService.getPropKey(protocol, prop.getKey()), prop.getValue());
            }
        }
    }

    private InetSocketAddress getServerSocketAddress(ServerConfig server) throws StartException {
        InetAddress destinationAddress;
        String ref = server.getOutgoingSocketBinding();
        OutboundSocketBinding binding = this.socketBindings.get(ref);
        if (ref == null) {
            throw MailMessages.MESSAGES.outboundSocketBindingNotAvailable(ref);
        }
        try {
            destinationAddress = binding.getDestinationAddress();
        }
        catch (UnknownHostException uhe) {
            throw MailMessages.MESSAGES.unknownOutboundSocketBindingDestination(uhe, ref);
        }
        return new InetSocketAddress(destinationAddress, binding.getDestinationPort());
    }

    public Session getValue() throws IllegalStateException, IllegalArgumentException {
        return Session.getInstance((Properties)this.props, (Authenticator)new PasswordAuthentication());
    }

    private static String getHostKey(String protocol) {
        return "mail." + protocol + ".host";
    }

    private static String getPortKey(String protocol) {
        return "mail." + protocol + ".port";
    }

    private static String getPropKey(String protocol, String name) {
        return "mail." + protocol + "." + name;
    }

    public class PasswordAuthentication
    extends Authenticator {
        protected javax.mail.PasswordAuthentication getPasswordAuthentication() {
            String protocol = this.getRequestingProtocol();
            Credentials c = null;
            if ("smtp".equals(protocol) && MailSessionService.this.config.getSmtpServer() != null) {
                c = MailSessionService.this.config.getSmtpServer().getCredentials();
            } else if ("pop3".equals(protocol) && MailSessionService.this.config.getPop3Server() != null) {
                c = MailSessionService.this.config.getPop3Server().getCredentials();
            } else if ("imap".equals(protocol) && MailSessionService.this.config.getImapServer() != null) {
                c = MailSessionService.this.config.getImapServer().getCredentials();
            }
            if (c == null) {
                for (CustomServerConfig ssc : MailSessionService.this.config.getCustomServers()) {
                    if (!ssc.getProtocol().equals(protocol)) continue;
                    c = ssc.getCredentials();
                    break;
                }
            }
            if (c != null) {
                return new javax.mail.PasswordAuthentication(c.getUsername(), c.getPassword());
            }
            return null;
        }
    }
}

