/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.jboss.logging.Logger;
import org.jboss.security.negotiation.Constants;
import org.jboss.security.negotiation.DelegationCredentialContext;
import org.jboss.security.negotiation.GSSUtil;
import org.jboss.security.negotiation.SecurityActions;

public class KerberosLoginModule
implements LoginModule {
    private static final Logger log = Logger.getLogger(KerberosLoginModule.class);
    public static final String DELEGATION_CREDENTIAL = "delegationCredential";
    public static final String ADD_GSS_CREDENTIAL = "addGSSCredential";
    public static final String CREDENTIAL_LIFETIME = "credentialLifetime";
    private static final String SUN_MODULE = "com.sun.security.auth.module.Krb5LoginModule";
    private static final String IBM_MODULE = "com.ibm.security.auth.module.Krb5LoginModule";
    private static Class<LoginModule> WRAPPED_CLASS;
    private DelegationCredential delegationCredential = DelegationCredential.IGNORE;
    private boolean addGssCredential;
    private int credentialLifetime = 0;
    private LoginModule wrapped;
    private Subject subject;
    private GSSCredential credential;
    private boolean usingWrappedLoginModule;
    private Subject intermediateSubject;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        if (options.containsKey(DELEGATION_CREDENTIAL)) {
            this.delegationCredential = DelegationCredential.valueOf((String)options.get(DELEGATION_CREDENTIAL));
        }
        log.tracef("delegationCredential=%s", (Object)this.delegationCredential);
        if (this.delegationCredential != DelegationCredential.REQUIRE) {
            this.wrapped = SecurityActions.newInstance(WRAPPED_CLASS);
            if (this.wrapped == null) {
                throw new IllegalStateException("Unable to instantiate Krb5LoginModule to wrap!");
            }
            HashMap tweakedOptions = new HashMap(options);
            tweakedOptions.remove(ADD_GSS_CREDENTIAL);
            tweakedOptions.remove(CREDENTIAL_LIFETIME);
            tweakedOptions.remove(DELEGATION_CREDENTIAL);
            this.wrapped.initialize(subject, callbackHandler, sharedState, tweakedOptions);
            log.trace((Object)"Initialised wrapped login module.");
        } else {
            log.trace((Object)"Skipping wrapped login module initialisation.");
        }
        this.subject = subject;
        this.addGssCredential = Boolean.parseBoolean((String)options.get(ADD_GSS_CREDENTIAL));
        log.tracef("addGssCredential=%b", (Object)this.addGssCredential);
        if (options.containsKey(CREDENTIAL_LIFETIME)) {
            if (!this.addGssCredential) {
                throw new IllegalStateException(String.format("Option '%s' has been specified within enabling '%s'", CREDENTIAL_LIFETIME, ADD_GSS_CREDENTIAL));
            }
            this.credentialLifetime = Integer.parseInt((String)options.get(CREDENTIAL_LIFETIME));
            if (this.credentialLifetime < 0) {
                this.credentialLifetime = Integer.MAX_VALUE;
            }
            log.tracef("credentialLifetime=%d", (Object)this.credentialLifetime);
        }
    }

    @Override
    public boolean login() throws LoginException {
        switch (this.delegationCredential) {
            case REQUIRE: {
                this.credential = DelegationCredentialContext.getDelegCredential();
                if (this.credential == null) {
                    throw new LoginException("Module configured to use delegated credential but no delegated credential available.");
                }
                log.trace((Object)"We have a delegation credential, login() is a success.");
                this.usingWrappedLoginModule = false;
                return true;
            }
            case USE: {
                this.credential = DelegationCredentialContext.getDelegCredential();
                if (this.credential != null) {
                    log.trace((Object)"We have a delegation credential, login() is a success.");
                    this.usingWrappedLoginModule = false;
                    return true;
                }
                log.trace((Object)"No delegation credential so falling through to use wrapped login module.");
            }
        }
        this.usingWrappedLoginModule = true;
        return this.wrapped.login();
    }

    @Override
    public boolean commit() throws LoginException {
        boolean response;
        if (this.usingWrappedLoginModule) {
            response = this.wrapped.commit();
            log.tracef("Called wrapped login module respone=%b", (Object)response);
            if (response && this.addGssCredential) {
                log.trace((Object)"Adding GSSCredential to populated Subject");
                final GSSManager manager = GSSManager.getInstance();
                try {
                    GSSCredential credential = Subject.doAs(this.subject, new PrivilegedExceptionAction<GSSCredential>(){

                        @Override
                        public GSSCredential run() throws Exception {
                            Set<KerberosPrincipal> principals = KerberosLoginModule.this.subject.getPrincipals(KerberosPrincipal.class);
                            if (principals.size() < 1) {
                                throw new LoginException("No KerberosPrincipal Found");
                            }
                            if (principals.size() > 1) {
                                throw new LoginException("Too Many KerberosPrincipals Found");
                            }
                            KerberosPrincipal principal = principals.iterator().next();
                            log.tracef("Creating GSSName for Principal '%s'", (Object)principal);
                            GSSName name = manager.createName(principal.getName(), GSSName.NT_USER_NAME, Constants.KERBEROS_V5);
                            return manager.createCredential(name, KerberosLoginModule.this.credentialLifetime, Constants.KERBEROS_V5, 1);
                        }
                    });
                    SecurityActions.addPrivateCredential(this.subject, credential);
                    log.trace((Object)"Added private credential.");
                    this.credential = credential;
                }
                catch (PrivilegedActionException e) {
                    Exception cause = e.getException();
                    if (cause instanceof LoginException) {
                        throw (LoginException)cause;
                    }
                    log.debug((Object)e);
                    throw new LoginException("Unable to create GSSCredential");
                }
            }
        } else {
            log.trace((Object)"Jumping straight to mapping of delegation credential.");
            this.intermediateSubject = GSSUtil.populateSubject(this.subject, this.addGssCredential, this.credential);
            response = true;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean abort() throws LoginException {
        try {
            if (this.usingWrappedLoginModule) {
                log.trace((Object)"Calling wrapped login module to abort.");
                boolean bl = this.wrapped.abort();
                return bl;
            }
            log.trace((Object)"No wrapped module call to abort.");
            boolean bl = true;
            return bl;
        }
        finally {
            this.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean logout() throws LoginException {
        try {
            if (this.usingWrappedLoginModule) {
                if (this.credential != null) {
                    log.trace((Object)"Remocing GSSCredential added to subject during authentication.");
                    SecurityActions.removePrivateCredential(this.subject, this.credential);
                }
                log.trace((Object)"Passing to wrapped login module to logout.");
                boolean bl = this.wrapped.logout();
                return bl;
            }
            log.trace((Object)"Removing credentials from Subject poplulated from delegation credential.");
            GSSUtil.clearSubject(this.subject, this.intermediateSubject, this.credential);
            boolean bl = true;
            return bl;
        }
        finally {
            this.cleanUp();
        }
    }

    private void cleanUp() {
        this.wrapped = null;
        this.subject = null;
        if (this.credential != null && this.usingWrappedLoginModule) {
            try {
                log.trace((Object)"Disposing of GSSCredential");
                this.credential.dispose();
            }
            catch (GSSException gSSException) {
                // empty catch block
            }
        }
        this.credential = null;
    }

    static {
        Class<LoginModule> wrappedClass = SecurityActions.loadLoginModuleClass(SUN_MODULE);
        if (wrappedClass == null) {
            wrappedClass = SecurityActions.loadLoginModuleClass(IBM_MODULE);
        }
        if (wrappedClass == null) {
            throw new IllegalStateException("Unable to locate any Krb5LoginModule");
        }
        if (log.isTraceEnabled()) {
            log.tracef("Wrapped Krb5LoginModule is '%s'", (Object)wrappedClass.getName());
        }
        WRAPPED_CLASS = wrappedClass;
    }

    private static enum DelegationCredential {
        IGNORE,
        REQUIRE,
        USE;

    }
}

