/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.HashSet;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DeprecatedResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.jacorb.IORSettingsDefinition;
import org.jboss.as.jacorb.JacORBMessages;
import org.jboss.as.jacorb.JacORBSubsystemDefinitions;
import org.jboss.as.jacorb.JacORBSubsystemParser;
import org.jboss.as.jacorb.JacORBSubsystemResource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class JacORBExtension
implements Extension {
    private static final JacORBSubsystemParser PARSER = JacORBSubsystemParser.INSTANCE;
    public static final String SUBSYSTEM_NAME = "jacorb";
    private static final String RESOURCE_NAME = JacORBExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 4;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    static final ModelVersion DEPRECATED_SINCE = ModelVersion.create((int)1, (int)4, (int)0);

    static ResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new DeprecatedResourceDescriptionResolver(SUBSYSTEM_NAME, prefix.toString(), RESOURCE_NAME, JacORBExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 4, 0);
        ManagementResourceRegistration subsystemRegistration = subsystem.registerSubsystemModel((ResourceDefinition)JacORBSubsystemResource.INSTANCE);
        subsystemRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)PARSER);
        if (context.isRegisterTransformers()) {
            JacORBExtension.registerTransformers_1_1(subsystem);
            JacORBExtension.registerTransformers_1_2(subsystem);
            JacORBExtension.registerTransformers_1_3(subsystem);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, JacORBSubsystemParser.Namespace.JacORB_1_0.getUriString(), (XMLElementReader)PARSER);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, JacORBSubsystemParser.Namespace.JacORB_1_1.getUriString(), (XMLElementReader)PARSER);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, JacORBSubsystemParser.Namespace.JacORB_1_2.getUriString(), (XMLElementReader)PARSER);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, JacORBSubsystemParser.Namespace.JacORB_1_3.getUriString(), (XMLElementReader)PARSER);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, JacORBSubsystemParser.Namespace.JacORB_1_4.getUriString(), (XMLElementReader)PARSER);
    }

    protected static void registerTransformers_1_1(SubsystemRegistration subsystem) {
        HashSet<String> expressionKeys = new HashSet<String>();
        for (AttributeDefinition def : JacORBSubsystemDefinitions.ATTRIBUTES_BY_NAME.values()) {
            if (!def.isAllowExpression()) continue;
            expressionKeys.add(def.getName());
        }
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        builder.rejectChildResource(IORSettingsDefinition.INSTANCE.getPathElement());
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, expressionKeys.toArray(new String[expressionKeys.size()]))).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                return JacORBMessages.MESSAGES.cannotUseSecurityClient();
            }

            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return attributeValue.getType() == ModelType.STRING && attributeValue.asString().equals("client");
            }
        }, new String[]{"security"})).setValueConverter((AttributeConverter)new AttributeConverter.DefaultAttributeConverter(){

            protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                String security = attributeValue.asString();
                if (security.equals("identity")) {
                    attributeValue.set("on");
                }
            }
        }, new String[]{"security"})).end();
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemRegistration)subsystem, (ModelVersionRange)ModelVersion.create((int)1, (int)1, (int)0));
    }

    protected static void registerTransformers_1_2(SubsystemRegistration subsystem) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        builder.rejectChildResource(IORSettingsDefinition.INSTANCE.getPathElement());
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemRegistration)subsystem, (ModelVersionRange)ModelVersion.create((int)1, (int)2, (int)0));
    }

    protected static void registerTransformers_1_3(SubsystemRegistration subsystem) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        builder.rejectChildResource(IORSettingsDefinition.INSTANCE.getPathElement());
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemRegistration)subsystem, (ModelVersionRange)ModelVersion.create((int)1, (int)3, (int)0));
    }
}

