/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.msc;

import java.util.Collection;
import org.jboss.as.clustering.msc.ServiceControllerFactory;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.value.Value;

public class DelegatingServiceBuilder<T>
implements ServiceBuilder<T> {
    private final ServiceBuilder<T> builder;
    private final ServiceControllerFactory factory;

    public DelegatingServiceBuilder(ServiceBuilder<T> builder, ServiceControllerFactory factory) {
        this.builder = builder;
        this.factory = factory;
    }

    public ServiceBuilder<T> addAliases(ServiceName ... aliases) {
        this.builder.addAliases(aliases);
        return this;
    }

    public ServiceBuilder<T> setInitialMode(ServiceController.Mode mode) {
        this.builder.setInitialMode(mode);
        return this;
    }

    public ServiceBuilder<T> addDependencies(ServiceName ... dependencies) {
        this.builder.addDependencies(dependencies);
        return this;
    }

    public ServiceBuilder<T> addDependencies(ServiceBuilder.DependencyType dependencyType, ServiceName ... dependencies) {
        this.builder.addDependencies(dependencyType, dependencies);
        return this;
    }

    public ServiceBuilder<T> addDependencies(Iterable<ServiceName> dependencies) {
        this.builder.addDependencies(dependencies);
        return this;
    }

    public ServiceBuilder<T> addDependencies(ServiceBuilder.DependencyType dependencyType, Iterable<ServiceName> dependencies) {
        this.builder.addDependencies(dependencyType, dependencies);
        return this;
    }

    public ServiceBuilder<T> addDependency(ServiceName dependency) {
        this.builder.addDependency(dependency);
        return this;
    }

    public ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency) {
        this.builder.addDependency(dependencyType, dependency);
        return this;
    }

    public ServiceBuilder<T> addDependency(ServiceName dependency, Injector<Object> target) {
        this.builder.addDependency(dependency, target);
        return this;
    }

    public ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency, Injector<Object> target) {
        this.builder.addDependency(dependencyType, dependency, target);
        return this;
    }

    public <I> ServiceBuilder<T> addDependency(ServiceName dependency, Class<I> type, Injector<I> target) {
        this.builder.addDependency(dependency, type, target);
        return this;
    }

    public <I> ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency, Class<I> type, Injector<I> target) {
        this.builder.addDependency(dependencyType, dependency, type, target);
        return this;
    }

    public <I> ServiceBuilder<T> addInjection(Injector<? super I> target, I value) {
        this.builder.addInjection(target, value);
        return this;
    }

    public <I> ServiceBuilder<T> addInjectionValue(Injector<? super I> target, Value<I> value) {
        this.builder.addInjectionValue(target, value);
        return this;
    }

    public ServiceBuilder<T> addInjection(Injector<? super T> target) {
        this.builder.addInjection(target);
        return this;
    }

    public ServiceBuilder<T> addMonitor(StabilityMonitor monitor) {
        this.builder.addMonitor(monitor);
        return this;
    }

    public ServiceBuilder<T> addMonitors(StabilityMonitor ... monitors) {
        this.builder.addMonitors(monitors);
        return this;
    }

    public ServiceBuilder<T> addListener(ServiceListener<? super T> listener) {
        this.builder.addListener(listener);
        return this;
    }

    public ServiceBuilder<T> addListener(ServiceListener<? super T> ... listeners) {
        this.builder.addListener(listeners);
        return this;
    }

    public ServiceBuilder<T> addListener(Collection<? extends ServiceListener<? super T>> listeners) {
        this.builder.addListener(listeners);
        return this;
    }

    public ServiceBuilder<T> addListener(ServiceListener.Inheritance inheritance, ServiceListener<? super T> listener) {
        this.builder.addListener(inheritance, listener);
        return this;
    }

    public ServiceBuilder<T> addListener(ServiceListener.Inheritance inheritance, ServiceListener<? super T> ... listeners) {
        this.builder.addListener(inheritance, listeners);
        return this;
    }

    public ServiceBuilder<T> addListener(ServiceListener.Inheritance inheritance, Collection<? extends ServiceListener<? super T>> listeners) {
        this.builder.addListener(inheritance, listeners);
        return this;
    }

    public ServiceController<T> install() {
        return this.factory.createServiceController(this.builder.install());
    }
}

