/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.repository.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.osgi.repository.RepositoryLogger;
import org.jboss.osgi.repository.URLResourceBuilderFactory;
import org.jboss.osgi.repository.XRepository;
import org.jboss.osgi.repository.spi.AbstractRepository;
import org.jboss.osgi.resolver.MavenCoordinates;
import org.jboss.osgi.resolver.XResourceBuilder;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class MavenArtifactRepository
extends AbstractRepository
implements XRepository {
    private static String JBOSS_NEXUS_BASE = "http://repository.jboss.org/nexus/content/groups/public";
    private static String MAVEN_CENTRAL_BASE = "http://repo1.maven.org/maven2";
    private final URL[] baserepos;

    public MavenArtifactRepository() {
        ArrayList<URL> repos = new ArrayList<URL>();
        String userhome = System.getProperty("user.home");
        File localrepo = new File(userhome + File.separator + ".m2" + File.separator + "repository");
        if (localrepo.isDirectory()) {
            repos.add(this.getBaseURL(localrepo.toURI().toString()));
        }
        repos.add(this.getBaseURL(JBOSS_NEXUS_BASE));
        repos.add(this.getBaseURL(MAVEN_CENTRAL_BASE));
        this.baserepos = repos.toArray(new URL[repos.size()]);
    }

    public Collection<Capability> findProviders(Requirement req) {
        String namespace = req.getNamespace();
        ArrayList<Capability> result = new ArrayList<Capability>();
        if ("maven.identity".equals(namespace)) {
            String mavenId = (String)req.getAttributes().get("maven.identity");
            MavenCoordinates coordinates = MavenCoordinates.parse((String)mavenId);
            RepositoryLogger.LOGGER.infoFindMavenProviders(coordinates);
            for (URL baseURL : this.baserepos) {
                URL url = coordinates.getArtifactURL(baseURL);
                try {
                    url.openStream().close();
                }
                catch (IOException e) {
                    RepositoryLogger.LOGGER.debugf("Cannot access input stream for: %s", (Object)url);
                    continue;
                }
                try {
                    XResourceBuilder builder = URLResourceBuilderFactory.create((URL)url, null, (boolean)true);
                    result.add((Capability)builder.addCapability("maven.identity", mavenId));
                    RepositoryLogger.LOGGER.infoFoundMavenResource(builder.getResource());
                    break;
                }
                catch (Exception ex) {
                    RepositoryLogger.LOGGER.errorCannotCreateResource((Throwable)ex, coordinates);
                }
            }
        }
        return result;
    }

    private URL getBaseURL(String basestr) {
        URL baseURL = null;
        try {
            baseURL = new URL(basestr);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return baseURL;
    }
}

