/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.support.finder;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.PolicyMetaData;
import org.jboss.security.xacml.sunxacml.VersionConstraints;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinder;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderModule;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderResult;
import org.jboss.security.xacml.sunxacml.support.finder.PolicyCollection;
import org.jboss.security.xacml.sunxacml.support.finder.PolicyReader;

public class StaticRefPolicyFinderModule
extends PolicyFinderModule {
    private List policyList;
    private PolicyCollection policies;
    private File schemaFile = null;
    private static final Logger logger = Logger.getLogger(StaticRefPolicyFinderModule.class.getName());

    public StaticRefPolicyFinderModule(List policyList) {
        this.policyList = policyList;
        this.policies = new PolicyCollection();
        String schemaName = System.getProperty("com.sun.xacml.PolicySchema");
        if (schemaName != null) {
            this.schemaFile = new File(schemaName);
        }
    }

    public StaticRefPolicyFinderModule(List policyList, String schemaFile) {
        this.policyList = policyList;
        this.policies = new PolicyCollection();
        if (schemaFile != null) {
            this.schemaFile = new File(schemaFile);
        }
    }

    @Override
    public boolean isIdReferenceSupported() {
        return true;
    }

    @Override
    public void init(PolicyFinder finder) {
        PolicyReader reader = new PolicyReader(finder, logger, this.schemaFile);
        for (String str : this.policyList) {
            AbstractPolicy policy = null;
            try {
                try {
                    URL url = new URL(str);
                    policy = reader.readPolicy(url);
                }
                catch (MalformedURLException murle) {
                    policy = reader.readPolicy(new File(str));
                }
                if (this.policies.addPolicy(policy) || !logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "tried to load the same policy multiple times: " + str);
            }
            catch (ParsingException pe) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "Error reading policy: " + str, pe);
            }
        }
    }

    @Override
    public PolicyFinderResult findPolicy(URI idReference, int type, VersionConstraints constraints, PolicyMetaData parentMetaData) {
        AbstractPolicy policy = this.policies.getPolicy(idReference.toString(), type, constraints);
        if (policy == null) {
            return new PolicyFinderResult();
        }
        return new PolicyFinderResult(policy);
    }
}

