/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.locators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.security.xacml.interfaces.AbstractLocator;
import org.jboss.security.xacml.jaxb.Option;
import org.jboss.security.xacml.sunxacml.finder.ResourceFinderModule;

public class ResourceLocator
extends ResourceFinderModule
implements AbstractLocator {
    private String identifier = null;
    private boolean resourceChildSupported = true;
    private boolean resourceDescendantSupported = true;
    private List<Option> options = new ArrayList<Option>();
    private Map<String, Object> map = new HashMap<String, Object>();

    @Override
    public void setOptions(List<Option> options) {
        this.options = options;
        try {
            this.processOptions();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T get(String key) {
        return (T)this.map.get(key);
    }

    @Override
    public <T> void set(String key, T obj) {
        this.map.put(key, obj);
    }

    @Override
    public String getIdentifier() {
        if (this.identifier == null) {
            return super.getIdentifier();
        }
        return this.identifier;
    }

    @Override
    public boolean isChildSupported() {
        return this.resourceChildSupported;
    }

    @Override
    public boolean isDescendantSupported() {
        return this.resourceDescendantSupported;
    }

    private void processOptions() throws Exception {
        for (Option option : this.options) {
            String tag = option.getName();
            List<Object> values = option.getContent();
            String value = (String)values.get(0);
            if ("identifier".equals(tag)) {
                this.identifier = value;
                continue;
            }
            if ("resourceChildSupport".equals(tag)) {
                this.resourceChildSupported = Boolean.parseBoolean(value);
                continue;
            }
            if (!"resourceDescendantSupport".equals(tag)) continue;
            this.resourceDescendantSupported = Boolean.parseBoolean(value);
        }
    }
}

