/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.bridge;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.MatchResult;
import org.jboss.security.xacml.sunxacml.PolicyMetaData;
import org.jboss.security.xacml.sunxacml.PolicySet;
import org.jboss.security.xacml.sunxacml.VersionConstraints;
import org.jboss.security.xacml.sunxacml.ctx.Status;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinder;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderModule;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderResult;

public class PolicySetFinderModule
extends PolicyFinderModule {
    private PolicySet policySet;
    private List<AbstractPolicy> policies = new ArrayList<AbstractPolicy>();
    protected PolicyFinder policyFinder = null;

    public PolicySetFinderModule() {
    }

    public PolicySetFinderModule(PolicySet policySet) {
        this.policySet = policySet;
    }

    public PolicySetFinderModule(PolicySet policySet, List<AbstractPolicy> policies) {
        this.policySet = policySet;
        this.policies.addAll(policies);
    }

    @Override
    public void init(PolicyFinder finder) {
        this.policyFinder = finder;
    }

    @Override
    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        PolicySet selectedPolicy = null;
        MatchResult match = this.policySet.match(context);
        int result = match.getResult();
        if (result == 2) {
            return new PolicyFinderResult(match.getStatus());
        }
        if (result == 0) {
            if (selectedPolicy != null) {
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                Status status = new Status(code, "too many applicable top-level policies");
                return new PolicyFinderResult(status);
            }
            selectedPolicy = this.policySet;
        }
        return new PolicyFinderResult(selectedPolicy);
    }

    @Override
    public PolicyFinderResult findPolicy(URI idReference, int type, VersionConstraints constraints, PolicyMetaData parentMetaData) {
        for (AbstractPolicy p : this.policies) {
            if (p.getId().compareTo(idReference) != 0) continue;
            return new PolicyFinderResult(p);
        }
        return new PolicyFinderResult();
    }

    @Override
    public boolean isRequestSupported() {
        return true;
    }

    @Override
    public boolean isIdReferenceSupported() {
        return true;
    }

    public void set(PolicySet ps, List<AbstractPolicy> policies) {
        this.policySet = ps;
        this.policies = policies;
    }
}

