/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.vault;

import java.io.Console;
import java.util.Scanner;
import org.jboss.as.security.vault.VaultInteractiveSession;
import org.jboss.as.security.vault.VaultSession;

public class VaultInteraction {
    private VaultSession vaultNISession;

    public VaultInteraction(VaultSession vaultSession) {
        this.vaultNISession = vaultSession;
    }

    public void start() {
        Console console = System.console();
        if (console == null) {
            System.err.println("No console.");
            System.exit(1);
        }
        Scanner in = new Scanner(System.in);
        block11: while (true) {
            String commandStr = "Please enter a Digit::  0: Store a secured attribute  1: Check whether a secured attribute exists  2: Remove secured attribute  3: Exit";
            System.out.println(commandStr);
            int choice = in.nextInt();
            switch (choice) {
                case 0: {
                    System.out.println("Task: Store a secured attribute");
                    char[] attributeValue = VaultInteractiveSession.getSensitiveValue("Please enter secured attribute value (such as password)");
                    String vaultBlock = null;
                    while (vaultBlock == null || vaultBlock.length() == 0) {
                        vaultBlock = console.readLine("Enter Vault Block:", new Object[0]);
                    }
                    String attributeName = null;
                    while (attributeName == null || attributeName.length() == 0) {
                        attributeName = console.readLine("Enter Attribute Name:", new Object[0]);
                    }
                    try {
                        this.vaultNISession.addSecuredAttributeWithDisplay(vaultBlock, attributeName, attributeValue);
                    }
                    catch (Exception e) {
                        System.out.println("Problem occurred:" + e.getLocalizedMessage());
                    }
                    continue block11;
                }
                case 1: {
                    String attributeName;
                    String vaultBlock;
                    System.out.println("Task: Verify whether a secured attribute exists");
                    try {
                        vaultBlock = null;
                        while (vaultBlock == null || vaultBlock.length() == 0) {
                            vaultBlock = console.readLine("Enter Vault Block:", new Object[0]);
                        }
                        attributeName = null;
                        while (attributeName == null || attributeName.length() == 0) {
                            attributeName = console.readLine("Enter Attribute Name:", new Object[0]);
                        }
                        if (!this.vaultNISession.checkSecuredAttribute(vaultBlock, attributeName)) {
                            System.out.println("No value has been store for (" + vaultBlock + ", " + attributeName + ")");
                            break;
                        }
                        System.out.println("A value exists for (" + vaultBlock + ", " + attributeName + ")");
                    }
                    catch (Exception e) {
                        System.out.println("Problem occurred:" + e.getLocalizedMessage());
                    }
                    continue block11;
                }
                case 2: {
                    String attributeName;
                    String vaultBlock;
                    System.out.println("Task: Remove secured attribute");
                    try {
                        vaultBlock = null;
                        while (vaultBlock == null || vaultBlock.length() == 0) {
                            vaultBlock = console.readLine("Enter Vault Block:", new Object[0]);
                        }
                        attributeName = null;
                        while (attributeName == null || attributeName.length() == 0) {
                            attributeName = console.readLine("Enter Attribute Name:", new Object[0]);
                        }
                        if (!this.vaultNISession.removeSecuredAttribute(vaultBlock, attributeName)) {
                            System.out.println("Secured attribute " + VaultSession.blockAttributeDisplayFormat(vaultBlock, attributeName) + " was not removed from vault, check whether it exist");
                            break;
                        }
                        System.out.println("Secured attribute " + VaultSession.blockAttributeDisplayFormat(vaultBlock, attributeName) + " has been successfuly removed from vault");
                    }
                    catch (Exception e) {
                        System.out.println("Problem occurred:" + e.getLocalizedMessage());
                    }
                    continue block11;
                }
                default: {
                    in.close();
                    System.exit(0);
                }
            }
        }
    }
}

