/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.vault;

import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.vault.SecurityActions;
import org.jboss.security.vault.SecurityVault;
import org.jboss.security.vault.SecurityVaultException;

public class SecurityVaultFactory {
    private static String defaultVault = "org.picketbox.plugins.vault.PicketBoxSecurityVault";
    private static SecurityVault vault = null;

    public static SecurityVault get() throws SecurityVaultException {
        return SecurityVaultFactory.get(defaultVault);
    }

    public static SecurityVault get(String fqn) throws SecurityVaultException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityVaultFactory.class.getName() + ".get"));
        }
        if (fqn == null) {
            return SecurityVaultFactory.get();
        }
        if (vault == null) {
            Class<?> vaultClass = SecurityActions.loadClass(SecurityVaultFactory.class, fqn);
            if (vaultClass == null) {
                throw new SecurityVaultException(PicketBoxMessages.MESSAGES.unableToLoadVaultMessage());
            }
            try {
                vault = (SecurityVault)vaultClass.newInstance();
            }
            catch (Exception e) {
                throw new SecurityVaultException(PicketBoxMessages.MESSAGES.unableToCreateVaultMessage(), e);
            }
        } else {
            SecurityVaultFactory.secondVaultInfo(null, fqn);
        }
        return vault;
    }

    public static SecurityVault get(ClassLoader classLoader, String fqn) throws SecurityVaultException {
        if (classLoader == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("classLoader");
        }
        if (fqn == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("fqn");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityVaultFactory.class.getName() + ".get"));
        }
        if (vault == null) {
            Class<?> vaultClass = SecurityActions.loadClass(classLoader, fqn);
            if (vaultClass == null) {
                throw new SecurityVaultException(PicketBoxMessages.MESSAGES.unableToLoadVaultMessage());
            }
            try {
                vault = (SecurityVault)vaultClass.newInstance();
            }
            catch (Exception e) {
                throw new SecurityVaultException(PicketBoxMessages.MESSAGES.unableToCreateVaultMessage(), e);
            }
        } else {
            SecurityVaultFactory.secondVaultInfo(classLoader.toString(), fqn);
        }
        return vault;
    }

    private static void secondVaultInfo(String module, String className) {
        PicketBoxLogger.LOGGER.attemptToCreateSecondVault(module != null ? className + " @ " + module : className);
    }
}

