/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.utils;

import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.ws.commons.schema.utils.XmlSchemaNamed;
import org.apache.ws.commons.schema.utils.XmlSchemaRefBase;

public class XmlSchemaNamedImpl
implements XmlSchemaNamed {
    protected XmlSchema parentSchema;
    protected XmlSchemaRefBase refTwin;
    private QName qname;
    private boolean topLevel;

    public XmlSchemaNamedImpl(XmlSchema parent, boolean topLevel) {
        this.parentSchema = parent;
        this.topLevel = topLevel;
    }

    public void setRefObject(XmlSchemaRefBase refBase) {
        this.refTwin = refBase;
    }

    @Override
    public String getName() {
        if (this.qname == null) {
            return null;
        }
        return this.qname.getLocalPart();
    }

    @Override
    public boolean isAnonymous() {
        return this.qname == null;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            this.qname = null;
        } else {
            if ("".equals(name)) {
                throw new XmlSchemaException("Attempt to set empty name.");
            }
            if (this.refTwin != null && this.refTwin.getTargetQName() != null) {
                throw new XmlSchemaException("Attempt to set name on object with ref='xxx'");
            }
            this.qname = new QName(this.parentSchema.getLogicalTargetNamespace(), name);
        }
    }

    @Override
    public XmlSchema getParent() {
        return this.parentSchema;
    }

    @Override
    public QName getQName() {
        return this.qname;
    }

    @Override
    public boolean isTopLevel() {
        return this.topLevel;
    }
}

