/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FragmentBundleRevision;
import org.jboss.osgi.framework.internal.FragmentBundleState;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.FrameworkWiringLock;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.framework.spi.ModuleManager;
import org.jboss.osgi.framework.spi.PackageAdminSupport;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.XResource;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Wire;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.RequiredBundle;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.startlevel.StartLevel;

public class PackageAdminImpl
implements PackageAdminSupport {
    private final BundleManagerPlugin bundleManager;
    private final XEnvironment environment;
    private final FrameworkEvents events;
    private final ModuleManager moduleManager;
    private final XResolver resolver;
    private final StartLevel startLevelPlugin;
    private final LockManager lockManager;
    private final ExecutorService executorService;
    private final AtomicBoolean immediateExecution;

    public PackageAdminImpl(BundleManager bundleManager, XEnvironment environment, FrameworkEvents events, ModuleManager moduleManager, XResolver resolver, StartLevel startLevelPlugin, LockManager lockManager, ExecutorService executorService, AtomicBoolean immediateExecution) {
        this.bundleManager = BundleManagerPlugin.assertBundleManagerPlugin(bundleManager);
        this.environment = environment;
        this.events = events;
        this.moduleManager = moduleManager;
        this.resolver = resolver;
        this.startLevelPlugin = startLevelPlugin;
        this.lockManager = lockManager;
        this.executorService = executorService;
        this.immediateExecution = immediateExecution;
    }

    @Override
    public void enableImmediateExecution(boolean enable) {
        this.immediateExecution.set(enable);
    }

    public ExportedPackage[] getExportedPackages(Bundle bundle2) {
        if (bundle2 == null) {
            return this.getAllExportedPackages();
        }
        if (!(bundle2 instanceof XBundle)) {
            return null;
        }
        if (this.bundleManager.getBundleById(bundle2.getBundleId()) == null) {
            return null;
        }
        ArrayList<ExportedPackageImpl> result = new ArrayList<ExportedPackageImpl>();
        XBundle bundleState = (XBundle)bundle2;
        for (XBundleRevision brev : bundleState.getAllBundleRevisions()) {
            if (brev.getWiring() == null) continue;
            for (Capability cap : brev.getCapabilities("osgi.wiring.package")) {
                XCapability xcap = (XCapability)cap;
                XPackageCapability packcap = (XPackageCapability)xcap.adapt(XPackageCapability.class);
                result.add(new ExportedPackageImpl(packcap));
            }
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new ExportedPackage[result.size()]);
    }

    private ExportedPackage[] getAllExportedPackages() {
        ArrayList<ExportedPackage> result = new ArrayList<ExportedPackage>();
        for (XBundle bundle2 : this.bundleManager.getBundles()) {
            ExportedPackage[] pkgs = this.getExportedPackages((Bundle)bundle2);
            if (pkgs == null) continue;
            result.addAll(Arrays.asList(pkgs));
        }
        return result.toArray(new ExportedPackage[result.size()]);
    }

    public ExportedPackage[] getExportedPackages(String name) {
        ExportedPackage[] pkgs = this.getExportedPackagesInternal(name);
        return pkgs.length == 0 ? null : pkgs;
    }

    private ExportedPackage[] getExportedPackagesInternal(String name) {
        assert (name != null) : "Null name";
        HashSet<ExportedPackageImpl> result = new HashSet<ExportedPackageImpl>();
        for (XResource res : this.environment.getResources(XEnvironment.ALL_IDENTITY_TYPES)) {
            XBundleRevision brev = (XBundleRevision)res;
            BundleWiring wiring = brev.getWiring();
            if (wiring == null || brev.isFragment()) continue;
            for (BundleCapability cap : wiring.getCapabilities("osgi.wiring.package")) {
                XCapability xcap = (XCapability)cap;
                XPackageCapability packcap = (XPackageCapability)xcap.adapt(XPackageCapability.class);
                if (!packcap.getPackageName().equals(name)) continue;
                result.add(new ExportedPackageImpl(packcap));
            }
        }
        return result.toArray(new ExportedPackage[result.size()]);
    }

    public ExportedPackage getExportedPackage(String name) {
        ExportedPackage[] exported = this.getExportedPackagesInternal(name);
        ArrayList<ExportedPackage> wired = new ArrayList<ExportedPackage>();
        ArrayList<ExportedPackage> notWired = new ArrayList<ExportedPackage>();
        for (ExportedPackage ep : exported) {
            XPackageCapability cap = ((ExportedPackageImpl)ep).getCapability();
            if (this.isWired(cap)) {
                wired.add(ep);
                continue;
            }
            notWired.add(ep);
        }
        ExportedPackageComparator comparator = new ExportedPackageComparator();
        Collections.sort(wired, comparator);
        Collections.sort(notWired, comparator);
        if (wired.size() > 0) {
            return (ExportedPackage)wired.get(0);
        }
        if (notWired.size() > 0) {
            return (ExportedPackage)notWired.get(0);
        }
        return null;
    }

    private boolean isWired(XPackageCapability cap) {
        BundleWiring wiring = ((BundleRevision)cap.getResource()).getWiring();
        if (wiring != null) {
            for (BundleWire wire : wiring.getProvidedWires(cap.getNamespace())) {
                if (!cap.equals(wire.getCapability())) continue;
                return true;
            }
            List requireBundleWires = wiring.getProvidedWires("osgi.wiring.bundle");
            if (requireBundleWires.size() > 0) {
                return true;
            }
        }
        return false;
    }

    public void refreshPackages(final Bundle[] bundles) {
        final ArrayList<Bundle> bundlesToRefresh = new ArrayList<Bundle>();
        if (bundles != null) {
            bundlesToRefresh.addAll(Arrays.asList(bundles));
        }
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LockManager.LockContext lockContext = null;
                try {
                    FrameworkWiringLock wireLock = PackageAdminImpl.this.lockManager.getItemForType(FrameworkWiringLock.class);
                    lockContext = PackageAdminImpl.this.lockManager.lockItems(LockManager.Method.REFRESH, wireLock);
                    if (bundles == null) {
                        for (XBundle bundle2 : PackageAdminImpl.this.bundleManager.getBundles(null)) {
                            UserBundleState userBundle;
                            if (bundle2.getBundleId() == 0L || !(bundle2 instanceof UserBundleState) || (userBundle = (UserBundleState)bundle2).getAllBundleRevisions().size() <= 1 && bundle2.getState() != 1) continue;
                            bundlesToRefresh.add(userBundle);
                        }
                    }
                    LinkedHashSet providedBundles = new LinkedHashSet();
                    for (Bundle bundle3 : bundlesToRefresh) {
                        if (!(bundle3 instanceof UserBundleState)) continue;
                        UserBundleState<?> bundleState = UserBundleState.assertBundleState(bundle3);
                        providedBundles.add(bundleState);
                    }
                    HashSet<HostBundleState> stopBundles = new HashSet<HostBundleState>();
                    HashSet<UserBundleState> refreshBundles = new HashSet<UserBundleState>();
                    HashSet<UserBundleState> uninstallBundles = new HashSet<UserBundleState>();
                    for (UserBundleState userBundleState : providedBundles) {
                        if (userBundleState.getState() == 1) {
                            uninstallBundles.add(userBundleState);
                            continue;
                        }
                        if (!userBundleState.isResolved()) continue;
                        refreshBundles.add(userBundleState);
                    }
                    block11: for (XBundle xBundle : PackageAdminImpl.this.bundleManager.getBundles(36)) {
                        if (!(xBundle instanceof HostBundleState)) continue;
                        HostBundleState hostBundle = HostBundleState.assertBundleState((Bundle)xBundle);
                        for (HostBundleState depBundle : hostBundle.getDependentBundles()) {
                            if (!providedBundles.contains(depBundle)) continue;
                            int state = hostBundle.getState();
                            if (state == 32 || state == 8) {
                                stopBundles.add(hostBundle);
                            }
                            refreshBundles.add(hostBundle);
                            continue block11;
                        }
                    }
                    for (UserBundleState userBundleState : refreshBundles) {
                        int state;
                        if (!(userBundleState instanceof HostBundleState) || (state = userBundleState.getState()) != 32 && state != 8) continue;
                        stopBundles.add((HostBundleState)userBundleState);
                    }
                    ArrayList stopList = new ArrayList(stopBundles);
                    ArrayList arrayList = new ArrayList(refreshBundles);
                    BundleStartLevelComparator startLevelComparator = new BundleStartLevelComparator(PackageAdminImpl.this.startLevelPlugin);
                    Collections.sort(stopList, startLevelComparator);
                    ListIterator it = stopList.listIterator(stopList.size());
                    while (it.hasPrevious()) {
                        HostBundleState hostBundle = (HostBundleState)it.previous();
                        try {
                            hostBundle.stop(1);
                        }
                        catch (Exception th) {
                            PackageAdminImpl.this.events.fireFrameworkEvent((Bundle)hostBundle, 2, th);
                        }
                    }
                    for (UserBundleState userBundle : uninstallBundles) {
                        PackageAdminImpl.this.bundleManager.removeBundle(userBundle, 0);
                    }
                    for (UserBundleState userBundle : arrayList) {
                        try {
                            userBundle.refresh();
                        }
                        catch (Exception th) {
                            PackageAdminImpl.this.events.fireFrameworkEvent((Bundle)userBundle, 2, th);
                        }
                    }
                    for (HostBundleState hostBundle : stopList) {
                        try {
                            hostBundle.start(1);
                        }
                        catch (Exception th) {
                            PackageAdminImpl.this.events.fireFrameworkEvent((Bundle)hostBundle, 2, th);
                        }
                    }
                    PackageAdminImpl.this.lockManager.unlockItems(lockContext);
                }
                catch (Throwable throwable) {
                    PackageAdminImpl.this.lockManager.unlockItems(lockContext);
                    throw throwable;
                }
                PackageAdminImpl.this.events.fireFrameworkEvent((Bundle)PackageAdminImpl.this.bundleManager.getSystemBundle(), 4, null);
            }
        };
        this.executeTask(runner);
    }

    public boolean resolveBundles(Bundle[] bundles) {
        if (bundles == null) {
            Set<XBundle> bundleset = this.bundleManager.getBundles(2);
            bundles = new Bundle[bundleset.size()];
            bundleset.toArray(bundles);
        }
        LinkedHashSet<XBundleRevision> resolve = new LinkedHashSet<XBundleRevision>();
        for (Bundle bundle2 : bundles) {
            XBundle bundleState = (XBundle)bundle2;
            resolve.add(bundleState.getBundleRevision());
        }
        boolean result = true;
        try {
            XResolveContext context = this.resolver.createResolveContext(this.environment, resolve, null);
            this.resolver.resolveAndApply(context);
            for (BundleRevision bundleRevision : resolve) {
                if (bundleRevision.getWiring() != null) continue;
                result = false;
                break;
            }
        }
        catch (ResolutionException ex) {
            FrameworkLogger.LOGGER.debugf(ex, "Cannot resolve: " + resolve, new Object[0]);
            result = false;
        }
        return result;
    }

    public RequiredBundle[] getRequiredBundles(String symbolicName) {
        ArrayList<HostBundleState> matchingHosts = new ArrayList<HostBundleState>();
        if (symbolicName != null) {
            for (XBundle aux : this.bundleManager.getBundles(symbolicName, null)) {
                if (!(aux instanceof HostBundleState)) continue;
                matchingHosts.add((HostBundleState)aux);
            }
        } else {
            for (XBundle aux : this.bundleManager.getBundles()) {
                if (!(aux instanceof HostBundleState)) continue;
                matchingHosts.add((HostBundleState)aux);
            }
        }
        if (matchingHosts.isEmpty()) {
            return null;
        }
        ArrayList<RequiredBundleImpl> result = new ArrayList<RequiredBundleImpl>();
        for (HostBundleState hostState : matchingHosts) {
            HostBundleRevision brev = hostState.getBundleRevision();
            HashSet<XBundle> requiringBundles = new HashSet<XBundle>();
            BundleWiring wiring = brev.getWiring();
            if (wiring != null) {
                List providedWires = wiring.getProvidedResourceWires("osgi.wiring.bundle");
                for (Wire wire : providedWires) {
                    XBundle bundle2 = ((XBundleRevision)wire.getRequirer()).getBundle();
                    requiringBundles.add(bundle2);
                }
            }
            result.add(new RequiredBundleImpl(hostState, (XBundleRevision)brev, requiringBundles));
        }
        return result.toArray(new RequiredBundle[matchingHosts.size()]);
    }

    public Bundle[] getBundles(final String symbolicName, String versionRange) {
        TreeSet<Bundle> sortedSet = new TreeSet<Bundle>(new Comparator<Bundle>(){

            @Override
            public int compare(Bundle b1, Bundle b2) {
                if (symbolicName == null) {
                    return (int)(b1.getBundleId() - b2.getBundleId());
                }
                return b2.getVersion().compareTo((Object)b1.getVersion());
            }
        });
        for (XBundle bundleState : this.bundleManager.getBundles(symbolicName, versionRange)) {
            if (bundleState.getState() == 1) continue;
            sortedSet.add((Bundle)bundleState);
        }
        if (sortedSet.isEmpty()) {
            return null;
        }
        return sortedSet.toArray(new Bundle[sortedSet.size()]);
    }

    public Bundle[] getFragments(Bundle bundle2) {
        if (!(bundle2 instanceof HostBundleState)) {
            return null;
        }
        HostBundleState hostBundle = HostBundleState.assertBundleState(bundle2);
        if (bundle2.getBundleId() == 0L || !hostBundle.isResolved()) {
            return null;
        }
        ArrayList<XBundle> result = new ArrayList<XBundle>();
        HostBundleRevision curRevision = hostBundle.getBundleRevision();
        for (FragmentBundleRevision aux : curRevision.getAttachedFragments()) {
            result.add(aux.getBundle());
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new Bundle[result.size()]);
    }

    public Bundle[] getHosts(Bundle bundle2) {
        if (!(bundle2 instanceof FragmentBundleState)) {
            return null;
        }
        FragmentBundleState fragBundle = FragmentBundleState.assertBundleState(bundle2);
        FragmentBundleRevision curRevision = fragBundle.getBundleRevision();
        ArrayList<XBundle> result = new ArrayList<XBundle>();
        for (HostBundleRevision aux : curRevision.getAttachedHosts()) {
            result.add(aux.getBundle());
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new Bundle[result.size()]);
    }

    public Bundle getBundle(Class clazz) {
        XBundle bundleState = this.moduleManager.getBundleState(clazz);
        return bundleState != null ? bundleState : null;
    }

    public int getBundleType(Bundle bundle2) {
        XBundleRevision brev = ((XBundle)bundle2).getBundleRevision();
        return brev.isFragment() ? 1 : 0;
    }

    private void executeTask(Runnable runner) {
        if (!this.executorService.isShutdown()) {
            if (this.immediateExecution.get()) {
                runner.run();
            } else {
                this.executorService.execute(runner);
            }
        }
    }

    private static class ExportedPackageComparator
    implements Comparator<ExportedPackage> {
        private ExportedPackageComparator() {
        }

        @Override
        public int compare(ExportedPackage ep1, ExportedPackage ep2) {
            return ep2.getVersion().compareTo((Object)ep1.getVersion());
        }
    }

    private static class BundleStartLevelComparator
    implements Comparator<HostBundleState> {
        private final StartLevel startLevelPlugin;

        BundleStartLevelComparator(StartLevel startLevel) {
            this.startLevelPlugin = startLevel;
        }

        @Override
        public int compare(HostBundleState o1, HostBundleState o2) {
            int sl2;
            int sl1 = this.startLevelPlugin.getBundleStartLevel((Bundle)o1);
            return sl1 < (sl2 = this.startLevelPlugin.getBundleStartLevel((Bundle)o2)) ? -1 : (sl1 == sl2 ? 0 : 1);
        }
    }

    static class RequiredBundleImpl
    implements RequiredBundle {
        private final XBundle requiredBundle;
        private final XBundle[] requiringBundles;
        private final XBundleRevision bundleRevision;

        RequiredBundleImpl(XBundle requiredBundle, XBundleRevision bundleRevision, Collection<XBundle> requiringBundles) {
            this.requiredBundle = requiredBundle;
            this.bundleRevision = bundleRevision;
            ArrayList<XBundle> bundles = new ArrayList<XBundle>(requiringBundles.size());
            for (XBundle bundle2 : requiringBundles) {
                bundles.add(bundle2);
            }
            this.requiringBundles = bundles.toArray(new XBundle[bundles.size()]);
        }

        public String getSymbolicName() {
            return this.requiredBundle.getSymbolicName();
        }

        public Bundle getBundle() {
            if (this.isRemovalPending()) {
                return null;
            }
            return this.requiredBundle;
        }

        public Bundle[] getRequiringBundles() {
            if (this.isRemovalPending()) {
                return null;
            }
            return this.requiringBundles;
        }

        public Version getVersion() {
            return this.requiredBundle.getVersion();
        }

        public boolean isRemovalPending() {
            if (this.requiredBundle.getState() == 1) {
                return true;
            }
            XBundle bundle2 = this.bundleRevision.getBundle();
            return !this.bundleRevision.equals(bundle2.getBundleRevision());
        }

        public String toString() {
            return "RequiredBundle[" + this.requiredBundle + "]";
        }
    }

    static class ExportedPackageImpl
    implements ExportedPackage {
        private final XPackageCapability capability;

        ExportedPackageImpl(XPackageCapability cap) {
            this.capability = cap;
        }

        public String getName() {
            return this.capability.getPackageName();
        }

        public Bundle getExportingBundle() {
            return ((BundleRevision)this.capability.getResource()).getBundle();
        }

        public Bundle[] getImportingBundles() {
            BundleRevision req;
            if (this.isRemovalPending()) {
                return null;
            }
            HashSet<Bundle> bundles = new HashSet<Bundle>();
            XBundleRevision resource = (XBundleRevision)this.capability.getResource();
            BundleWiring wiring = resource.getWiring();
            for (BundleWire wire : wiring.getProvidedWires("osgi.wiring.package")) {
                req = wire.getRequirer();
                bundles.add(req.getBundle());
            }
            for (BundleWire wire : wiring.getProvidedWires("osgi.wiring.bundle")) {
                req = wire.getRequirer();
                bundles.add(req.getBundle());
            }
            return bundles.toArray(new Bundle[bundles.size()]);
        }

        public String getSpecificationVersion() {
            return this.capability.getVersion().toString();
        }

        public Version getVersion() {
            return this.capability.getVersion();
        }

        public boolean isRemovalPending() {
            XBundleRevision brev = (XBundleRevision)this.capability.getResource();
            XBundle bundle2 = brev.getBundle();
            if (bundle2 instanceof AbstractBundleState && ((AbstractBundleState)bundle2).isUninstalled()) {
                return true;
            }
            return brev != bundle2.getBundleRevision();
        }

        private XPackageCapability getCapability() {
            return this.capability;
        }

        public String toString() {
            return "ExportedPackage[" + this.capability + "]";
        }
    }
}

