/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleRevision;

final class FragmentBundleRevision
extends UserBundleRevision {
    private Set<HostBundleRevision> attachedHosts;

    FragmentBundleRevision(FrameworkState frameworkState, Deployment dep, OSGiMetaData metadata, StorageState storageState) throws BundleException {
        super(frameworkState, dep, metadata, storageState);
    }

    static FragmentBundleRevision assertFragmentRevision(BundleRevision brev) {
        assert (brev instanceof FragmentBundleRevision) : "Not an FragmentRevision: " + brev;
        return (FragmentBundleRevision)brev;
    }

    @Override
    void refreshRevisionInternal() {
        this.attachedHosts = null;
    }

    Set<HostBundleRevision> getAttachedHosts() {
        if (this.attachedHosts == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.attachedHosts);
    }

    @Override
    Class<?> loadClass(String className) throws ClassNotFoundException {
        throw FrameworkMessages.MESSAGES.cannotLoadClassFromFragment((BundleRevision)this);
    }

    public URL getResource(String resourceName) {
        return null;
    }

    public Enumeration<URL> getResources(String resourceName) {
        return null;
    }

    void attachToHost(HostBundleRevision hostRev) {
        if (this.attachedHosts == null) {
            this.attachedHosts = new HashSet<HostBundleRevision>();
        }
        hostRev.attachFragment(this);
        this.attachedHosts.add(hostRev);
    }

    @Override
    URL getLocalizationEntry(String path) {
        URL result = null;
        boolean fallbackToFragment = true;
        if (this.getWiring() != null) {
            HostBundleRevision highest = null;
            for (HostBundleRevision hostrev : this.getAttachedHosts()) {
                if (highest == null) {
                    highest = hostrev;
                }
                if (highest.getVersion().compareTo((Object)hostrev.getVersion()) >= 0) continue;
                highest = hostrev;
            }
            if (highest == null) {
                throw FrameworkMessages.MESSAGES.illegalStateCannotObtainAttachedHost((BundleRevision)this);
            }
            boolean hostUninstalled = highest.getBundleState().isUninstalled();
            URL uRL = result = hostUninstalled ? this.getEntry(path) : highest.getLocalizationEntry(path);
            if (result != null || !fallbackToFragment) {
                return result;
            }
        }
        result = this.getEntry(path);
        return result;
    }
}

