/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.xml.namespace.QName;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.api.saml.v2.sig.SAML2Signature;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.web.handlers.saml2.AbstractSignatureHandler;
import org.picketlink.identity.federation.web.util.RedirectBindingSignatureUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2SignatureGenerationHandler
extends AbstractSignatureHandler {
    public static final String SIGN_ASSERTION_ONLY = "SIGN_ASSERTION_ONLY";
    public static final String SIGN_RESPONSE_AND_ASSERTION = "SIGN_RESPONSE_AND_ASSERTION";

    @Override
    public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        Document samlDocument = response.getResultingDocument();
        if (samlDocument == null) {
            logger.trace("No document generated in the handler chain. Cannot generate signature");
            return;
        }
        this.sign(samlDocument, request, response);
    }

    @Override
    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        Document responseDocument = response.getResultingDocument();
        if (responseDocument == null) {
            logger.trace("No response document found");
            return;
        }
        this.sign(responseDocument, request, response);
    }

    @Override
    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        Document responseDocument = response.getResultingDocument();
        if (responseDocument == null) {
            logger.trace("No response document found");
            return;
        }
        this.sign(responseDocument, request, response);
    }

    private void sign(Document samlDocument, SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (!this.isSupportsSignature(request)) {
            return;
        }
        KeyPair keypair = (KeyPair)this.handlerChainConfig.getParameter("KEYPAIR");
        X509Certificate x509Certificate = (X509Certificate)this.handlerChainConfig.getParameter("X509CERTIFICATE");
        if (keypair == null) {
            logger.samlHandlerKeyPairNotFound();
            throw logger.samlHandlerKeyPairNotFoundError();
        }
        if (this.isSAMLResponse(samlDocument)) {
            if (this.isSignAssertionOnly() || this.isSignResponseAndAssertion()) {
                Document temporaryDocument;
                Element originalAssertionElement = DocumentUtil.getChildElement((Element)samlDocument.getDocumentElement(), (QName)new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ASSERTION.get()));
                Node clonedAssertionElement = originalAssertionElement.cloneNode(true);
                try {
                    temporaryDocument = DocumentUtil.createDocument();
                }
                catch (ConfigurationException e) {
                    throw logger.processingError((Throwable)e);
                }
                temporaryDocument.adoptNode(clonedAssertionElement);
                temporaryDocument.appendChild(clonedAssertionElement);
                this.signDocument(temporaryDocument, keypair, x509Certificate);
                samlDocument.adoptNode(clonedAssertionElement);
                Element parentNode = (Element)originalAssertionElement.getParentNode();
                parentNode.replaceChild(clonedAssertionElement, originalAssertionElement);
            }
            if (!this.isSignAssertionOnly()) {
                this.signDocument(samlDocument, keypair, x509Certificate);
            }
        } else {
            this.signDocument(samlDocument, keypair, x509Certificate);
        }
        if (!response.isPostBindingForResponse()) {
            logger.trace("Going to sign response document with REDIRECT binding type");
            String destinationQueryString = this.signRedirect(samlDocument, response.getRelayState(), keypair, response.getSendRequest());
            response.setDestinationQueryStringWithSignature(destinationQueryString);
        }
    }

    private void signDocument(Document samlDocument, KeyPair keypair, X509Certificate x509Certificate) throws ProcessingException {
        SAML2Signature samlSignature = new SAML2Signature();
        Node nextSibling = samlSignature.getNextSiblingOfIssuer(samlDocument);
        samlSignature.setNextSibling(nextSibling);
        if (x509Certificate != null) {
            samlSignature.setX509Certificate(x509Certificate);
        }
        logger.trace("Going to sign document.");
        samlSignature.signSAMLDocument(samlDocument, keypair);
    }

    private String signRedirect(Document samlDocument, String relayState, KeyPair keypair, boolean willSendRequest) throws ProcessingException {
        try {
            String samlMessage = DocumentUtil.getDocumentAsString((Document)samlDocument);
            String base64Request = RedirectBindingUtil.deflateBase64URLEncode(samlMessage.getBytes("UTF-8"));
            PrivateKey signingKey = keypair.getPrivate();
            if (StringUtil.isNotNull((String)relayState)) {
                relayState = RedirectBindingUtil.urlEncode(relayState);
            }
            String url = willSendRequest ? RedirectBindingSignatureUtil.getSAMLRequestURLWithSignature(base64Request, relayState, signingKey) : RedirectBindingSignatureUtil.getSAMLResponseURLWithSignature(base64Request, relayState, signingKey);
            return url;
        }
        catch (ConfigurationException ce) {
            logger.samlHandlerErrorSigningRedirectBindingMessage((Throwable)ce);
            throw logger.samlHandlerSigningRedirectBindingMessageError((Throwable)ce);
        }
        catch (GeneralSecurityException ce) {
            logger.samlHandlerErrorSigningRedirectBindingMessage((Throwable)ce);
            throw logger.samlHandlerSigningRedirectBindingMessageError((Throwable)ce);
        }
        catch (IOException ce) {
            logger.samlHandlerErrorSigningRedirectBindingMessage((Throwable)ce);
            throw logger.samlHandlerSigningRedirectBindingMessageError((Throwable)ce);
        }
    }

    private boolean isSAMLResponse(Document samlDocument) {
        return samlDocument.getDocumentElement().getLocalName().equals(JBossSAMLConstants.RESPONSE.get());
    }

    private boolean isSignAssertionOnly() {
        return this.handlerConfig.getParameter(SIGN_ASSERTION_ONLY) != null ? Boolean.valueOf(this.handlerConfig.getParameter(SIGN_ASSERTION_ONLY).toString()) : false;
    }

    private boolean isSignResponseAndAssertion() {
        return this.handlerConfig.getParameter(SIGN_RESPONSE_AND_ASSERTION) != null ? Boolean.valueOf(this.handlerConfig.getParameter(SIGN_RESPONSE_AND_ASSERTION).toString()) : false;
    }
}

