/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.HashSet;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ListValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.dmr.ModelNode;

public class Validators {
    public static ListValidator noDuplicateElements(ParameterValidator elementValidator) {
        return new ListValidator(elementValidator, false, 1, Integer.MAX_VALUE){

            public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                super.validateParameter(parameterName, value);
                int elementsSize = value.asList().size();
                HashSet set = new HashSet(value.asList());
                if (set.size() != elementsSize) {
                    throw MessagingMessages.MESSAGES.duplicateElements(parameterName, value);
                }
            }
        };
    }

    public static void validateNoDuplicateElements(ListAttributeDefinition definition, ModelNode model) throws OperationFailedException {
        ListValidator listValidator = Validators.noDuplicateElements(definition.getElementValidator());
        listValidator.validateParameter(definition.getName(), model.get(definition.getName()));
    }
}

