/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.EnumSet;
import java.util.Locale;
import org.hornetq.api.core.management.HornetQServerControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.messaging.HornetQActivationService;
import org.jboss.as.messaging.ManagementUtil;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class HornetQServerControlHandler
extends AbstractRuntimeOnlyHandler {
    static final HornetQServerControlHandler INSTANCE = new HornetQServerControlHandler();
    public static final AttributeDefinition ACTIVE = SimpleAttributeDefinitionBuilder.create((String)"active", (ModelType)ModelType.BOOLEAN).setStorageRuntime().build();
    public static final AttributeDefinition STARTED = new SimpleAttributeDefinition("started", ModelType.BOOLEAN, false, new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME});
    public static final AttributeDefinition VERSION = new SimpleAttributeDefinition("version", ModelType.STRING, false, new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME});
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{STARTED, VERSION, ACTIVE};
    public static final String GET_CONNECTORS_AS_JSON = "get-connectors-as-json";
    public static final String RESET_ALL_MESSAGE_COUNTERS = "reset-all-message-counters";
    public static final String RESET_ALL_MESSAGE_COUNTER_HISTORIES = "reset-all-message-counter-histories";
    public static final String LIST_PREPARED_TRANSACTIONS = "list-prepared-transactions";
    public static final String LIST_PREPARED_TRANSACTION_DETAILS_AS_JSON = "list-prepared-transaction-details-as-json";
    public static final String LIST_PREPARED_TRANSACTION_DETAILS_AS_HTML = "list-prepared-transaction-details-as-html";
    public static final String LIST_HEURISTIC_COMMITTED_TRANSACTIONS = "list-heuristic-committed-transactions";
    public static final String LIST_HEURISTIC_ROLLED_BACK_TRANSACTIONS = "list-heuristic-rolled-back-transactions";
    public static final String COMMIT_PREPARED_TRANSACTION = "commit-prepared-transaction";
    public static final String ROLLBACK_PREPARED_TRANSACTION = "rollback-prepared-transaction";
    public static final String LIST_REMOTE_ADDRESSES = "list-remote-addresses";
    public static final String CLOSE_CONNECTIONS_FOR_ADDRESS = "close-connections-for-address";
    public static final String CLOSE_CONNECTIONS_FOR_USER = "close-connections-for-user";
    public static final String CLOSE_CONSUMER_CONNECTIONS_FOR_ADDRESS = "close-consumer-connections-for-address";
    public static final String LIST_CONNECTION_IDS = "list-connection-ids";
    public static final String LIST_PRODUCERS_INFO_AS_JSON = "list-producers-info-as-json";
    public static final String LIST_SESSIONS = "list-sessions";
    public static final String GET_ROLES = "get-roles";
    @Deprecated
    public static final String GET_ROLES_AS_JSON = "get-roles-as-json";
    public static final String GET_ADDRESS_SETTINGS_AS_JSON = "get-address-settings-as-json";
    public static final String FORCE_FAILOVER = "force-failover";
    public static final String HQ_SERVER = "hornetq-server";
    public static final String TRANSACTION_AS_BASE_64 = "transaction-as-base-64";
    public static final String ADDRESS_MATCH = "address-match";
    public static final String CONNECTION_ID = "connection-id";
    public static final String IP_ADDRESS = "ip-address";
    private final ParametersValidator transactionValidator = new ParametersValidator();
    private final ParametersValidator addressMatchValidator = new ParametersValidator();
    private final ParametersValidator ipAddressValidator = new ParametersValidator();
    private final ParametersValidator userValidator = new ParametersValidator();
    private final ParametersValidator optionalIpAddressValidator = new ParametersValidator();
    private final ParametersValidator connectionIdValidator = new ParametersValidator();

    private HornetQServerControlHandler() {
        StringLengthValidator stringLengthValidator = new StringLengthValidator(1);
        this.transactionValidator.registerValidator(TRANSACTION_AS_BASE_64, (ParameterValidator)stringLengthValidator);
        this.addressMatchValidator.registerValidator(ADDRESS_MATCH, (ParameterValidator)stringLengthValidator);
        this.ipAddressValidator.registerValidator(IP_ADDRESS, (ParameterValidator)stringLengthValidator);
        this.userValidator.registerValidator("user", (ParameterValidator)stringLengthValidator);
        this.optionalIpAddressValidator.registerValidator(IP_ADDRESS, (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false));
        this.connectionIdValidator.registerValidator(CONNECTION_ID, (ParameterValidator)stringLengthValidator);
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        block27: {
            String operationName = operation.require("operation").asString();
            ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
            ServiceController hqService = context.getServiceRegistry(false).getService(hqServiceName);
            if (hqService == null || hqService.getState() != ServiceController.State.UP) {
                throw MessagingMessages.MESSAGES.hornetQServerNotInstalled(hqServiceName.getSimpleName());
            }
            HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
            if ("read-attribute".equals(operationName)) {
                this.handleReadAttribute(context, operation, hqServer);
                context.stepCompleted();
                return;
            }
            if (HornetQActivationService.rollbackOperationIfServerNotActive(context, operation)) {
                return;
            }
            HornetQServerControl serverControl = this.getServerControl(context, operation);
            try {
                if (GET_CONNECTORS_AS_JSON.equals(operationName)) {
                    String json = serverControl.getConnectorsAsJSON();
                    context.getResult().set(json);
                    break block27;
                }
                if (RESET_ALL_MESSAGE_COUNTERS.equals(operationName)) {
                    serverControl.resetAllMessageCounters();
                    context.getResult();
                    break block27;
                }
                if (RESET_ALL_MESSAGE_COUNTER_HISTORIES.equals(operationName)) {
                    serverControl.resetAllMessageCounterHistories();
                    context.getResult();
                    break block27;
                }
                if (LIST_PREPARED_TRANSACTIONS.equals(operationName)) {
                    String[] list = serverControl.listPreparedTransactions();
                    ManagementUtil.reportListOfString(context, list);
                    break block27;
                }
                if (LIST_PREPARED_TRANSACTION_DETAILS_AS_JSON.equals(operationName)) {
                    String json = serverControl.listPreparedTransactionDetailsAsJSON();
                    context.getResult().set(json);
                    break block27;
                }
                if (LIST_PREPARED_TRANSACTION_DETAILS_AS_HTML.equals(operationName)) {
                    String html = serverControl.listPreparedTransactionDetailsAsHTML();
                    context.getResult().set(html);
                    break block27;
                }
                if (LIST_HEURISTIC_COMMITTED_TRANSACTIONS.equals(operationName)) {
                    String[] list = serverControl.listHeuristicCommittedTransactions();
                    ManagementUtil.reportListOfString(context, list);
                    break block27;
                }
                if (LIST_HEURISTIC_ROLLED_BACK_TRANSACTIONS.equals(operationName)) {
                    String[] list = serverControl.listHeuristicRolledBackTransactions();
                    ManagementUtil.reportListOfString(context, list);
                    break block27;
                }
                if (COMMIT_PREPARED_TRANSACTION.equals(operationName)) {
                    this.transactionValidator.validate(operation);
                    String txId = operation.require(TRANSACTION_AS_BASE_64).asString();
                    boolean committed = serverControl.commitPreparedTransaction(txId);
                    context.getResult().set(committed);
                    break block27;
                }
                if (ROLLBACK_PREPARED_TRANSACTION.equals(operationName)) {
                    this.transactionValidator.validate(operation);
                    String txId = operation.require(TRANSACTION_AS_BASE_64).asString();
                    boolean committed = serverControl.rollbackPreparedTransaction(txId);
                    context.getResult().set(committed);
                    break block27;
                }
                if (LIST_REMOTE_ADDRESSES.equals(operationName)) {
                    this.optionalIpAddressValidator.validate(operation);
                    ModelNode addr = operation.get(IP_ADDRESS);
                    String[] list = addr.isDefined() ? serverControl.listRemoteAddresses(addr.asString()) : serverControl.listRemoteAddresses();
                    ManagementUtil.reportListOfString(context, list);
                    break block27;
                }
                if (CLOSE_CONNECTIONS_FOR_ADDRESS.equals(operationName)) {
                    this.ipAddressValidator.validate(operation);
                    boolean closed = serverControl.closeConnectionsForAddress(operation.require(IP_ADDRESS).asString());
                    context.getResult().set(closed);
                    break block27;
                }
                if (CLOSE_CONNECTIONS_FOR_USER.equals(operationName)) {
                    this.userValidator.validate(operation);
                    String user = operation.require("user").asString();
                    boolean closed = serverControl.closeConnectionsForUser(user);
                    context.getResult().set(closed);
                    break block27;
                }
                if (CLOSE_CONSUMER_CONNECTIONS_FOR_ADDRESS.equals(operationName)) {
                    this.addressMatchValidator.validate(operation);
                    String addressMatch = operation.require(ADDRESS_MATCH).asString();
                    boolean closed = serverControl.closeConsumerConnectionsForAddress(addressMatch);
                    context.getResult().set(closed);
                    break block27;
                }
                if (LIST_CONNECTION_IDS.equals(operationName)) {
                    String[] list = serverControl.listConnectionIDs();
                    ManagementUtil.reportListOfString(context, list);
                    break block27;
                }
                if (LIST_PRODUCERS_INFO_AS_JSON.equals(operationName)) {
                    String json = serverControl.listProducersInfoAsJSON();
                    context.getResult().set(json);
                    break block27;
                }
                if (LIST_SESSIONS.equals(operationName)) {
                    this.connectionIdValidator.validate(operation);
                    String[] list = serverControl.listSessions(operation.require(CONNECTION_ID).asString());
                    ManagementUtil.reportListOfString(context, list);
                    break block27;
                }
                if (GET_ROLES.equals(operationName)) {
                    this.addressMatchValidator.validate(operation);
                    String json = serverControl.getRolesAsJSON(operation.require(ADDRESS_MATCH).asString());
                    ManagementUtil.reportRoles(context, json);
                    break block27;
                }
                if (GET_ROLES_AS_JSON.equals(operationName)) {
                    this.addressMatchValidator.validate(operation);
                    String json = serverControl.getRolesAsJSON(operation.require(ADDRESS_MATCH).asString());
                    ManagementUtil.reportRolesAsJSON(context, json);
                    break block27;
                }
                if (GET_ADDRESS_SETTINGS_AS_JSON.equals(operationName)) {
                    this.addressMatchValidator.validate(operation);
                    String json = serverControl.getAddressSettingsAsJSON(operation.require(ADDRESS_MATCH).asString());
                    context.getResult().set(json);
                    break block27;
                }
                if (FORCE_FAILOVER.equals(operationName)) {
                    serverControl.forceFailover();
                    context.getResult();
                    break block27;
                }
                throw MessagingMessages.MESSAGES.unsupportedOperation(operationName);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        for (AttributeDefinition attr : ATTRIBUTES) {
            registry.registerReadOnlyAttribute(attr, (OperationStepHandler)this);
        }
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        EnumSet<OperationEntry.Flag> readOnly = EnumSet.of(OperationEntry.Flag.READ_ONLY);
        EnumSet<OperationEntry.Flag> runtimeOnly = EnumSet.of(OperationEntry.Flag.RUNTIME_ONLY);
        EnumSet<OperationEntry.Flag> readOnlyRuntimeOnly = EnumSet.of(OperationEntry.Flag.READ_ONLY, OperationEntry.Flag.RUNTIME_ONLY);
        registry.registerOperationHandler(GET_CONNECTORS_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, HornetQServerControlHandler.GET_CONNECTORS_AS_JSON, HornetQServerControlHandler.HQ_SERVER, ModelType.STRING, true);
            }
        }, readOnly);
        registry.registerOperationHandler(RESET_ALL_MESSAGE_COUNTERS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getDescriptionOnlyOperation(locale, HornetQServerControlHandler.RESET_ALL_MESSAGE_COUNTERS, HornetQServerControlHandler.HQ_SERVER);
            }
        }, runtimeOnly);
        registry.registerOperationHandler(RESET_ALL_MESSAGE_COUNTER_HISTORIES, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getDescriptionOnlyOperation(locale, HornetQServerControlHandler.RESET_ALL_MESSAGE_COUNTER_HISTORIES, HornetQServerControlHandler.HQ_SERVER);
            }
        }, runtimeOnly);
        registry.registerOperationHandler(LIST_PREPARED_TRANSACTIONS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleListReplyOperation(locale, HornetQServerControlHandler.LIST_PREPARED_TRANSACTIONS, HornetQServerControlHandler.HQ_SERVER, ModelType.STRING, true);
            }
        }, readOnlyRuntimeOnly);
        registry.registerOperationHandler(LIST_PREPARED_TRANSACTION_DETAILS_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, HornetQServerControlHandler.LIST_PREPARED_TRANSACTION_DETAILS_AS_JSON, HornetQServerControlHandler.HQ_SERVER, ModelType.STRING, true);
            }
        }, readOnlyRuntimeOnly);
        registry.registerOperationHandler(LIST_PREPARED_TRANSACTION_DETAILS_AS_HTML, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, HornetQServerControlHandler.LIST_PREPARED_TRANSACTION_DETAILS_AS_HTML, HornetQServerControlHandler.HQ_SERVER, ModelType.STRING, true);
            }
        }, readOnlyRuntimeOnly);
        registry.registerOperationHandler(LIST_HEURISTIC_COMMITTED_TRANSACTIONS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleListReplyOperation(locale, HornetQServerControlHandler.LIST_HEURISTIC_COMMITTED_TRANSACTIONS, HornetQServerControlHandler.HQ_SERVER, ModelType.STRING, true);
            }
        }, readOnlyRuntimeOnly);
        registry.registerOperationHandler(LIST_HEURISTIC_ROLLED_BACK_TRANSACTIONS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleListReplyOperation(locale, HornetQServerControlHandler.LIST_HEURISTIC_ROLLED_BACK_TRANSACTIONS, HornetQServerControlHandler.HQ_SERVER, ModelType.STRING, true);
            }
        }, readOnlyRuntimeOnly);
        registry.registerOperationHandler(COMMIT_PREPARED_TRANSACTION, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSingleParamSimpleReplyOperation(locale, HornetQServerControlHandler.COMMIT_PREPARED_TRANSACTION, HornetQServerControlHandler.HQ_SERVER, HornetQServerControlHandler.TRANSACTION_AS_BASE_64, ModelType.STRING, true, ModelType.BOOLEAN, true);
            }
        }, runtimeOnly);
        registry.registerOperationHandler(ROLLBACK_PREPARED_TRANSACTION, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSingleParamSimpleReplyOperation(locale, HornetQServerControlHandler.ROLLBACK_PREPARED_TRANSACTION, HornetQServerControlHandler.HQ_SERVER, HornetQServerControlHandler.TRANSACTION_AS_BASE_64, ModelType.STRING, true, ModelType.BOOLEAN, true);
            }
        }, runtimeOnly);
        registry.registerOperationHandler(LIST_REMOTE_ADDRESSES, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSingleParamSimpleListReplyOperation(locale, HornetQServerControlHandler.LIST_REMOTE_ADDRESSES, HornetQServerControlHandler.HQ_SERVER, HornetQServerControlHandler.IP_ADDRESS, ModelType.STRING, true, ModelType.STRING, true);
            }
        }, readOnlyRuntimeOnly);
        registry.registerOperationHandler(CLOSE_CONNECTIONS_FOR_ADDRESS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSingleParamSimpleReplyOperation(locale, HornetQServerControlHandler.CLOSE_CONNECTIONS_FOR_ADDRESS, HornetQServerControlHandler.HQ_SERVER, HornetQServerControlHandler.IP_ADDRESS, ModelType.STRING, false, ModelType.BOOLEAN, true);
            }
        }, runtimeOnly);
        registry.registerOperationHandler(CLOSE_CONNECTIONS_FOR_USER, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSingleParamSimpleReplyOperation(locale, HornetQServerControlHandler.CLOSE_CONNECTIONS_FOR_USER, HornetQServerControlHandler.HQ_SERVER, "user", ModelType.STRING, false, ModelType.BOOLEAN, true);
            }
        }, runtimeOnly);
        registry.registerOperationHandler(CLOSE_CONSUMER_CONNECTIONS_FOR_ADDRESS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSingleParamSimpleReplyOperation(locale, HornetQServerControlHandler.CLOSE_CONSUMER_CONNECTIONS_FOR_ADDRESS, HornetQServerControlHandler.HQ_SERVER, HornetQServerControlHandler.ADDRESS_MATCH, ModelType.STRING, false, ModelType.BOOLEAN, true);
            }
        }, runtimeOnly);
        registry.registerOperationHandler(LIST_CONNECTION_IDS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleListReplyOperation(locale, HornetQServerControlHandler.LIST_CONNECTION_IDS, HornetQServerControlHandler.HQ_SERVER, ModelType.STRING, true);
            }
        }, readOnlyRuntimeOnly);
        registry.registerOperationHandler(LIST_PRODUCERS_INFO_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, HornetQServerControlHandler.LIST_PRODUCERS_INFO_AS_JSON, HornetQServerControlHandler.HQ_SERVER, ModelType.STRING, true);
            }
        }, readOnlyRuntimeOnly);
        registry.registerOperationHandler(LIST_SESSIONS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSingleParamSimpleListReplyOperation(locale, HornetQServerControlHandler.LIST_SESSIONS, HornetQServerControlHandler.HQ_SERVER, HornetQServerControlHandler.CONNECTION_ID, ModelType.STRING, true, ModelType.STRING, true);
            }
        }, readOnlyRuntimeOnly);
        registry.registerOperationHandler(GET_ROLES, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getGetRoles(locale);
            }
        }, readOnlyRuntimeOnly);
        registry.registerOperationHandler(GET_ROLES_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSingleParamSimpleReplyOperation(locale, HornetQServerControlHandler.GET_ROLES_AS_JSON, HornetQServerControlHandler.HQ_SERVER, HornetQServerControlHandler.ADDRESS_MATCH, ModelType.STRING, false, ModelType.STRING, true);
            }
        }, readOnlyRuntimeOnly);
        registry.registerOperationHandler(GET_ADDRESS_SETTINGS_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSingleParamSimpleReplyOperation(locale, HornetQServerControlHandler.GET_ADDRESS_SETTINGS_AS_JSON, HornetQServerControlHandler.HQ_SERVER, HornetQServerControlHandler.ADDRESS_MATCH, ModelType.STRING, false, ModelType.STRING, true);
            }
        }, readOnlyRuntimeOnly);
        registry.registerOperationHandler(FORCE_FAILOVER, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getDescriptionOnlyOperation(locale, HornetQServerControlHandler.FORCE_FAILOVER, HornetQServerControlHandler.HQ_SERVER);
            }
        }, runtimeOnly);
    }

    private void handleReadAttribute(OperationContext context, ModelNode operation, HornetQServer server) throws OperationFailedException {
        String name = operation.require("name").asString();
        if (STARTED.getName().equals(name)) {
            boolean started = server.isStarted();
            context.getResult().set(started);
        } else if (VERSION.getName().equals(name)) {
            String version = server.getVersion().getFullVersion();
            context.getResult().set(version);
        } else if (ACTIVE.getName().equals(name)) {
            boolean active = server.isActive();
            context.getResult().set(active);
        } else {
            throw MessagingMessages.MESSAGES.unsupportedAttribute(name);
        }
    }

    private HornetQServerControl getServerControl(OperationContext context, ModelNode operation) throws OperationFailedException {
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController hqService = context.getServiceRegistry(false).getService(hqServiceName);
        if (hqService == null || hqService.getState() != ServiceController.State.UP) {
            throw MessagingMessages.MESSAGES.hornetQServerNotInstalled(hqServiceName.getSimpleName());
        }
        HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
        return hqServer.getHornetQServerControl();
    }

    public static void main(String[] args) {
        Integer id = new Integer(123456);
        System.out.println(id.toString().equals(id));
    }
}

