/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.subsystem;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.naming.subsystem.NamingBindingResourceDefinition;
import org.jboss.as.naming.subsystem.NamingSubsystemXMLAttribute;
import org.jboss.as.naming.subsystem.NamingSubsystemXMLElement;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class NamingSubsystemXMLPersister
implements XMLElementWriter<SubsystemMarshallingContext> {
    public static final NamingSubsystemXMLPersister INSTANCE = new NamingSubsystemXMLPersister();

    private NamingSubsystemXMLPersister() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        ModelNode service;
        context.startSubsystemElement("urn:jboss:domain:naming:1.4", false);
        ModelNode model = context.getModelNode();
        if (model.hasDefined("binding")) {
            writer.writeStartElement(NamingSubsystemXMLElement.BINDINGS.getLocalName());
            ModelNode bindingModel = model.get("binding");
            this.writeBindings(writer, bindingModel);
            writer.writeEndElement();
        }
        if (model.hasDefined("service") && (service = model.get("service")).has("remote-naming")) {
            writer.writeEmptyElement("remote-naming");
        }
        writer.writeEndElement();
    }

    private void writeBindings(XMLExtendedStreamWriter writer, ModelNode bindingModel) throws XMLStreamException {
        for (Property binding : bindingModel.asPropertyList()) {
            String type = binding.getValue().get("binding-type").asString();
            if (type.equals("simple")) {
                this.writeSimpleBinding(binding, writer);
                continue;
            }
            if (type.equals("object-factory")) {
                this.writeObjectFactoryBinding(binding, writer);
                continue;
            }
            if (type.equals("lookup")) {
                this.writeLookupBinding(binding, writer);
                continue;
            }
            if (type.equals("external-context")) {
                this.writeExternalContext(binding, writer);
                continue;
            }
            throw new XMLStreamException("Unknown binding type " + type);
        }
    }

    private void writeSimpleBinding(Property binding, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(NamingSubsystemXMLElement.SIMPLE.getLocalName());
        writer.writeAttribute(NamingSubsystemXMLAttribute.NAME.getLocalName(), binding.getName());
        NamingBindingResourceDefinition.VALUE.marshallAsAttribute(binding.getValue(), (XMLStreamWriter)writer);
        NamingBindingResourceDefinition.TYPE.marshallAsAttribute(binding.getValue(), (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeObjectFactoryBinding(Property binding, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(NamingSubsystemXMLElement.OBJECT_FACTORY.getLocalName());
        writer.writeAttribute(NamingSubsystemXMLAttribute.NAME.getLocalName(), binding.getName());
        NamingBindingResourceDefinition.MODULE.marshallAsAttribute(binding.getValue(), (XMLStreamWriter)writer);
        NamingBindingResourceDefinition.CLASS.marshallAsAttribute(binding.getValue(), (XMLStreamWriter)writer);
        NamingBindingResourceDefinition.ENVIRONMENT.marshallAsElement(binding.getValue(), (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeExternalContext(Property binding, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(NamingSubsystemXMLElement.EXTERNAL_CONTEXT.getLocalName());
        writer.writeAttribute(NamingSubsystemXMLAttribute.NAME.getLocalName(), binding.getName());
        NamingBindingResourceDefinition.MODULE.marshallAsAttribute(binding.getValue(), (XMLStreamWriter)writer);
        NamingBindingResourceDefinition.CLASS.marshallAsAttribute(binding.getValue(), (XMLStreamWriter)writer);
        NamingBindingResourceDefinition.CACHE.marshallAsAttribute(binding.getValue(), (XMLStreamWriter)writer);
        NamingBindingResourceDefinition.ENVIRONMENT.marshallAsElement(binding.getValue(), (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeLookupBinding(Property binding, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(NamingSubsystemXMLElement.LOOKUP.getLocalName());
        writer.writeAttribute(NamingSubsystemXMLAttribute.NAME.getLocalName(), binding.getName());
        NamingBindingResourceDefinition.LOOKUP.marshallAsAttribute(binding.getValue(), (XMLStreamWriter)writer);
        writer.writeEndElement();
    }
}

