/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing.operation;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.DefaultStateWithEndCharacter;
import org.jboss.as.cli.parsing.GlobalCharacterHandlers;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.QuotesState;
import org.jboss.as.cli.parsing.WordCharacterHandler;

public class HeaderValueState
extends DefaultParsingState {
    public static final HeaderValueState INSTANCE = new HeaderValueState();
    public static final String ID = "HEADER_VALUE";

    HeaderValueState() {
        super(ID);
        this.putHandler(';', GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
        this.putHandler('}', GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
        this.enterState('\"', QuotesState.QUOTES_INCLUDED);
        this.enterState('[', new DefaultStateWithEndCharacter("BRACKETS", ']', true, true, this.enterStateHandlers));
        this.enterState('(', new DefaultStateWithEndCharacter("PARENTHESIS", ')', true, true, this.enterStateHandlers));
        this.enterState('{', new DefaultStateWithEndCharacter("BRACES", '}', true, true, this.enterStateHandlers));
        this.setEnterHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                if (ctx.begins("${")) {
                    ctx.replaceProperty(true);
                } else if (ctx.getCharacter() != '=') {
                    ctx.getCallbackHandler().character(ctx);
                }
            }
        });
        this.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_ON);
        this.setReturnHandler(GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
        this.setIgnoreWhitespaces(true);
    }

    @Override
    public boolean lockValueIndex() {
        return true;
    }
}

