/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.Verifier;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.convert.Converter;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConverterConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String CONVERTER = "converter";
    private static final String CONVERTER_ID = "converter-id";
    private static final String CONVERTER_FOR_CLASS = "converter-for-class";
    private static final String CONVERTER_CLASS = "converter-class";

    public void process(ServletContext servletContext, Document[] documentArray) throws Exception {
        for (int i = 0; i < documentArray.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing converter elements for document: ''{0}''", documentArray[i].getDocumentURI()));
            }
            String string = documentArray[i].getDocumentElement().getNamespaceURI();
            NodeList nodeList = documentArray[i].getDocumentElement().getElementsByTagNameNS(string, CONVERTER);
            if (nodeList == null || nodeList.getLength() <= 0) continue;
            this.addConverters(nodeList, string);
        }
        this.invokeNext(servletContext, documentArray);
    }

    private void addConverters(NodeList nodeList, String string) {
        Application application = this.getApplication();
        Verifier verifier = Verifier.getCurrentInstance();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            NodeList nodeList2 = ((Element)node).getElementsByTagNameNS(string, "*");
            String string2 = null;
            String string3 = null;
            String string4 = null;
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                Node node2 = nodeList2.item(j);
                if (CONVERTER_ID.equals(node2.getLocalName())) {
                    string2 = this.getNodeText(node2);
                    continue;
                }
                if (CONVERTER_CLASS.equals(node2.getLocalName())) {
                    string3 = this.getNodeText(node2);
                    continue;
                }
                if (!CONVERTER_FOR_CLASS.equals(node2.getLocalName())) continue;
                string4 = this.getNodeText(node2);
            }
            if (string2 != null && string3 != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("[Converter by ID] Calling Application.addConverter({0}, {1}", string2, string3));
                }
                if (verifier != null) {
                    verifier.validateObject(Verifier.ObjectType.CONVERTER, string3, Converter.class);
                }
                application.addConverter(string2, string3);
                continue;
            }
            if (string3 == null || string4 == null) continue;
            try {
                Class clazz = Util.loadClass(string4, this.getClass());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("[Converter for Class] Calling Application.addConverter({0}, {1}", string4, string3));
                }
                if (verifier != null) {
                    verifier.validateObject(Verifier.ObjectType.CONVERTER, string3, Converter.class);
                }
                application.addConverter(clazz, string3);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConfigurationException(classNotFoundException);
            }
        }
    }
}

