/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fusesource.jansi.AnsiOutputStream;
import org.fusesource.jansi.WindowsAnsiOutputStream;
import org.fusesource.jansi.internal.WindowsSupport;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.terminal.AbstractTerminal;
import org.jboss.aesh.terminal.POSIXTerminal;
import org.jboss.aesh.terminal.TerminalSize;
import org.jboss.aesh.util.LoggerUtil;

public class WindowsTerminal
extends AbstractTerminal {
    private Writer stdOut;
    private Writer stdErr;
    private InputStream input;
    private int width;
    private int height;
    private TerminalSize size;
    private long ttyPropsLastFetched;
    private static long TIMEOUT_PERIOD = 2000L;
    private static final Logger logger = LoggerUtil.getLogger(POSIXTerminal.class.getName());

    public WindowsTerminal() {
        super(logger);
    }

    @Override
    public void init(InputStream inputStream, OutputStream stdOut, OutputStream stdErr) {
        try {
            this.stdOut = new PrintWriter(new OutputStreamWriter(new WindowsAnsiOutputStream(stdOut)));
            this.stdErr = new PrintWriter(new OutputStreamWriter(new WindowsAnsiOutputStream(stdErr)));
        }
        catch (Exception ioe) {
            this.stdOut = new PrintWriter(new OutputStreamWriter(new AnsiOutputStream(stdOut)));
            this.stdErr = new PrintWriter(new OutputStreamWriter(new AnsiOutputStream(stdErr)));
        }
        this.input = inputStream;
    }

    @Override
    public int[] read(boolean readAhead) throws IOException {
        if (Settings.getInstance().isAnsiConsole()) {
            return new int[]{WindowsSupport.readByte()};
        }
        int input = this.input.read();
        int available = this.input.available();
        if (available > 1 && readAhead) {
            int[] in = new int[available];
            in[0] = input;
            for (int c = 1; c < available; ++c) {
                in[c] = this.input.read();
            }
            return in;
        }
        return new int[]{input};
    }

    @Override
    public void writeToStdOut(String out) throws IOException {
        if (out != null && out.length() > 0) {
            this.stdOut.write(out);
            this.stdOut.flush();
        }
    }

    @Override
    public void writeToStdOut(char[] out) throws IOException {
        if (out != null && out.length > 0) {
            this.stdOut.write(out);
            this.stdOut.flush();
        }
    }

    @Override
    public void writeToStdOut(char out) throws IOException {
        this.stdOut.write(out);
        this.stdOut.flush();
    }

    @Override
    public void writeToStdErr(String err) throws IOException {
        if (err != null && err.length() > 0) {
            this.stdOut.write(err);
            this.stdOut.flush();
        }
    }

    @Override
    public void writeToStdErr(char[] err) throws IOException {
        if (err != null && err.length > 0) {
            this.stdOut.write(err);
            this.stdOut.flush();
        }
    }

    @Override
    public void writeToStdErr(char err) throws IOException {
        this.stdOut.write(err);
        this.stdOut.flush();
    }

    private int getHeight() {
        int height = WindowsSupport.getWindowsTerminalHeight();
        this.ttyPropsLastFetched = System.currentTimeMillis();
        if (height < 1) {
            if (Settings.getInstance().isLogging()) {
                logger.log(Level.SEVERE, "Fetched terminal height is " + height + ", setting it to 24");
            }
            height = 24;
        }
        return height;
    }

    private int getWidth() {
        int width = WindowsSupport.getWindowsTerminalWidth();
        this.ttyPropsLastFetched = System.currentTimeMillis();
        if (width < 1) {
            if (Settings.getInstance().isLogging()) {
                logger.log(Level.SEVERE, "Fetched terminal width is " + width + ", setting it to 80");
            }
            width = 80;
        }
        return width;
    }

    @Override
    public TerminalSize getSize() {
        if (this.propertiesTimedOut()) {
            if (this.size == null) {
                this.size = new TerminalSize(this.getHeight(), this.getWidth());
            } else {
                this.size.setHeight(this.getHeight());
                this.size.setWidth(this.getWidth());
            }
        }
        return this.size;
    }

    @Override
    public boolean isEchoEnabled() {
        return false;
    }

    @Override
    public void reset() throws IOException {
    }

    private boolean propertiesTimedOut() {
        return System.currentTimeMillis() - this.ttyPropsLastFetched > TIMEOUT_PERIOD;
    }
}

