/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.jpa;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.persistence.EntityManagerFactory;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.jpa.spi.PersistenceUnitService;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.resolver.XBundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class PersistenceUnitProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        ServiceName puServiceName = (ServiceName)depUnit.getAttachment(JpaAttachments.PERSISTENCE_UNIT_SERVICE_KEY);
        XBundle bundle = (XBundle)depUnit.getAttachment(OSGiConstants.BUNDLE_KEY);
        if (bundle == null || puServiceName == null) {
            return;
        }
        BundleManager bundleManager = (BundleManager)depUnit.getAttachment(OSGiConstants.BUNDLE_MANAGER_KEY);
        EntityManagerFactoryRegistration.addService(phaseContext.getServiceTarget(), bundleManager, puServiceName, bundle);
    }

    public void undeploy(DeploymentUnit context) {
    }

    static class EntityManagerFactoryRegistration
    implements Service<ServiceRegistration> {
        private final InjectedValue<XBundle> injectedBundle = new InjectedValue();
        private final InjectedValue<PersistenceUnitService> injectedPersistenceUnitService = new InjectedValue();
        private ServiceRegistration registration;

        EntityManagerFactoryRegistration() {
        }

        static void addService(ServiceTarget serviceTarget, BundleManager bundleManager, ServiceName puServiceName, XBundle bundle) {
            ServiceName activeBundleName = bundleManager.getServiceName(bundle, 32);
            ServiceName serviceName = activeBundleName.append(new String[]{EntityManagerFactory.class.getSimpleName()});
            EntityManagerFactoryRegistration service = new EntityManagerFactoryRegistration();
            ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)service);
            builder.addDependency(puServiceName, PersistenceUnitService.class, service.injectedPersistenceUnitService);
            builder.addDependency(activeBundleName, XBundle.class, service.injectedBundle);
            builder.setInitialMode(ServiceController.Mode.PASSIVE);
            builder.install();
        }

        public void start(StartContext context) throws StartException {
            PersistenceUnitService puService = (PersistenceUnitService)this.injectedPersistenceUnitService.getValue();
            BundleContext bundleContext = ((XBundle)this.injectedBundle.getValue()).getBundleContext();
            EntityManagerFactory emf = puService.getEntityManagerFactory();
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("osgi.unit.name", puService.getScopedPersistenceUnitName());
            ((Dictionary)properties).put("osgi.unit.version", "unknown");
            ((Dictionary)properties).put("osgi.unit.provider", "unknown");
            this.registration = bundleContext.registerService(EntityManagerFactory.class.getName(), (Object)emf, properties);
        }

        public void stop(StopContext context) {
            if (this.registration != null) {
                this.registration.unregister();
                this.registration = null;
            }
        }

        public ServiceRegistration getValue() throws IllegalStateException, IllegalArgumentException {
            return this.registration;
        }
    }
}

