/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.UnknownHostException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.SocketBindingRemoveHandler;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.services.net.BindingAddHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class BindingRemoveHandler
extends SocketBindingRemoveHandler {
    public static final BindingRemoveHandler INSTANCE = new BindingRemoveHandler();

    private BindingRemoveHandler() {
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        ServiceController.Substate substate;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ServiceName svcName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{name});
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController controller = registry.getService(svcName);
        ServiceController.Substate substate2 = substate = controller == null ? null : controller.getSubstate();
        if (!context.isResourceServiceRestartAllowed() || substate != null && substate.getState() == ServiceController.State.UP && substate.isRestState()) {
            context.reloadRequired();
        } else {
            context.removeService(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{name}));
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ServiceName svcName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{name});
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController controller = registry.getService(svcName);
        if (controller != null) {
            context.revertReloadRequired();
        } else {
            try {
                BindingAddHandler.installBindingService(context, model, name, null);
            }
            catch (UnknownHostException e) {
                throw new OperationFailedException(new ModelNode().set(e.toString()));
            }
        }
    }
}

