/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.moduleservice;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.moduleservice.ModuleDefinition;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.vfs.VFSUtils;

public class ExternalModuleSpecService
implements Service<ModuleDefinition> {
    private final ModuleIdentifier moduleIdentifier;
    private final File file;
    private volatile ModuleDefinition moduleDefinition;
    private volatile JarFile jarFile;

    public ExternalModuleSpecService(ModuleIdentifier moduleIdentifier, File file) {
        this.moduleIdentifier = moduleIdentifier;
        this.file = file;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            this.jarFile = new JarFile(this.file);
        }
        catch (IOException e) {
            throw new StartException((Throwable)e);
        }
        ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)this.moduleIdentifier);
        ExternalModuleSpecService.addResourceRoot(specBuilder, this.jarFile);
        ModuleIdentifier javaee = ModuleIdentifier.create((String)"javaee.api");
        specBuilder.addDependency(DependencySpec.createModuleDependencySpec((ModuleIdentifier)javaee));
        specBuilder.addDependency(DependencySpec.createLocalDependencySpec());
        ModuleSpec moduleSpec = specBuilder.create();
        this.moduleDefinition = new ModuleDefinition(this.moduleIdentifier, Collections.<ModuleDependency>emptySet(), moduleSpec);
        ServiceModuleLoader.installModuleResolvedService(context.getChildTarget(), this.moduleIdentifier);
    }

    public synchronized void stop(StopContext context) {
        VFSUtils.safeClose((ZipFile)this.jarFile);
        this.jarFile = null;
        this.moduleDefinition = null;
    }

    public ModuleDefinition getValue() throws IllegalStateException, IllegalArgumentException {
        return this.moduleDefinition;
    }

    private static void addResourceRoot(ModuleSpec.Builder specBuilder, JarFile file) {
        specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createJarResourceLoader((String)file.getName(), (JarFile)file)));
    }
}

