/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class ProfileDescribeHandler
implements OperationStepHandler {
    public static final ProfileDescribeHandler INSTANCE = new ProfileDescribeHandler();
    private static final Set<Action.ActionEffect> DESCRIBE_EFFECTS = Collections.unmodifiableSet(EnumSet.of(Action.ActionEffect.ADDRESS, Action.ActionEffect.READ_CONFIG));

    private ProfileDescribeHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String opName = operation.require("operation").asString();
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        AuthorizationResult authResult = context.authorize(operation, DESCRIBE_EFFECTS);
        if (authResult.getDecision() != AuthorizationResult.Decision.PERMIT) {
            throw ControllerMessages.MESSAGES.unauthorized(opName, address, authResult.getExplanation());
        }
        final ModelNode result = new ModelNode();
        ModelNode profile = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        result.setEmptyList();
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        final AtomicReference failureRef = new AtomicReference();
        final ModelNode subsystemResults = new ModelNode().setEmptyList();
        final HashMap<String, ModelNode> includeResults = new HashMap<String, ModelNode>();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                boolean failed = false;
                if (failureRef.get() != null) {
                    context.getFailureDescription().set((ModelNode)failureRef.get());
                    failed = true;
                } else {
                    for (ModelNode includeRsp : includeResults.values()) {
                        if (includeRsp.hasDefined("failure-description")) {
                            context.getFailureDescription().set(includeRsp.get("failure-description"));
                            failed = true;
                            break;
                        }
                        ModelNode includeResult = includeRsp.get("result");
                        if (!includeResult.isDefined()) continue;
                        for (ModelNode op : includeResult.asList()) {
                            result.add(op);
                        }
                    }
                }
                if (!failed) {
                    for (ModelNode subsysRsp : subsystemResults.asList()) {
                        result.add(subsysRsp);
                    }
                    context.getResult().set(result);
                }
                context.stepCompleted();
            }
        }, OperationContext.Stage.IMMEDIATE);
        if (profile.hasDefined("subsystem")) {
            for (String subsystemName : profile.get("subsystem").keys()) {
                final ModelNode subsystemRsp = new ModelNode();
                PathElement pe = PathElement.pathElement((String)"subsystem", (String)subsystemName);
                PathAddress fullAddress = address.append(new PathElement[]{pe});
                ModelNode subsystemAddress = fullAddress.toModelNode();
                ModelNode newOp = operation.clone();
                newOp.get("address").set(subsystemAddress);
                PathAddress relativeAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{pe});
                OperationStepHandler subsysHandler = registry.getOperationHandler(relativeAddress, opName);
                if (subsysHandler == null) {
                    ImmutableManagementResourceRegistration child = registry.getSubModel(relativeAddress);
                    String errMsg = child == null ? ControllerMessages.MESSAGES.noSuchResourceType(fullAddress) : ControllerMessages.MESSAGES.noHandlerForOperation(opName, fullAddress);
                    throw new OperationFailedException(new ModelNode(errMsg));
                }
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        if (failureRef.get() == null) {
                            if (subsystemRsp.hasDefined("failure-description")) {
                                failureRef.set(subsystemRsp.get("failure-description"));
                            } else if (subsystemRsp.hasDefined("result")) {
                                for (ModelNode op : subsystemRsp.require("result").asList()) {
                                    subsystemResults.add(op);
                                }
                            }
                        }
                        context.stepCompleted();
                    }
                }, OperationContext.Stage.IMMEDIATE);
                context.addStep(subsystemRsp, newOp, subsysHandler, OperationContext.Stage.IMMEDIATE);
            }
        }
        if (profile.hasDefined("includes")) {
            for (ModelNode include : profile.get("includes").asList()) {
                String includeName = include.asString();
                ModelNode includeRsp = new ModelNode();
                includeResults.put(includeName, includeRsp);
                ModelNode includeAddress = address.subAddress(0, address.size() - 1).append(new PathElement[]{PathElement.pathElement((String)"profile", (String)includeName)}).toModelNode();
                ModelNode newOp = operation.clone();
                newOp.get("address").set(includeAddress);
                context.addStep(includeRsp, newOp, (OperationStepHandler)INSTANCE, OperationContext.Stage.IMMEDIATE);
            }
        }
        context.stepCompleted();
    }
}

