/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jboss.ejb.client.ClusterNodeManager;
import org.jboss.ejb.client.ClusterNodeSelector;
import org.jboss.ejb.client.DaemonThreadFactory;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.RandomClusterNodeSelector;
import org.jboss.logging.Logger;

@Deprecated
public final class ClusterContext
implements EJBClientContext.EJBReceiverContextCloseHandler {
    private static final Logger logger = Logger.getLogger(ClusterContext.class);
    private static final ExecutorService executorService = Executors.newCachedThreadPool(new DaemonThreadFactory("ejb-client-cluster-node-connection-creation"));
    private final String clusterName;
    private final EJBClientContext clientContext;
    private final Map<String, ClusterNodeManager> nodeManagers = Collections.synchronizedMap(new HashMap());
    private long maxClusterNodeOpenConnections = 10L;
    private ClusterNodeSelector clusterNodeSelector = new RandomClusterNodeSelector();
    private final Set<ClusterContextListener> clusterContextListeners = new HashSet<ClusterContextListener>();
    private final Set<String> connectedNodes = Collections.synchronizedSet(new HashSet());

    ClusterContext(String clusterName, EJBClientContext clientContext, EJBClientConfiguration ejbClientConfiguration) {
        this.clusterName = clusterName;
        this.clientContext = clientContext;
        if (ejbClientConfiguration != null && ejbClientConfiguration.getClusterConfiguration(this.clusterName) != null) {
            EJBClientConfiguration.ClusterConfiguration clusterConfiguration = ejbClientConfiguration.getClusterConfiguration(this.clusterName);
            this.setupClusterSpecificConfigurations(clusterConfiguration);
        } else {
            this.maxClusterNodeOpenConnections = 10L;
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public EJBClientContext getEJBClientContext() {
        return this.clientContext;
    }

    EJBReceiverContext getEJBReceiverContext(EJBClientInvocationContext invocationContext) {
        HashSet<String> excludedNodes = invocationContext == null ? new HashSet<String>() : new HashSet<String>(invocationContext.getExcludedNodes());
        return this.getEJBReceiverContext(invocationContext, excludedNodes);
    }

    private EJBReceiverContext getEJBReceiverContext(EJBClientInvocationContext invocationContext, Set<String> excludedNodes) {
        Set<String> nodesInThisCluster;
        EJBReceiver ejbReceiver;
        EJBLocator<?> ejbLocator = invocationContext.getLocator();
        if (this.nodeManagers.isEmpty()) {
            return null;
        }
        Set<String> availableNodes = this.nodeManagers.keySet();
        availableNodes.removeAll(excludedNodes);
        if (availableNodes.isEmpty()) {
            logger.debug("No nodes available in cluster " + this.clusterName + " for selecting a receiver context");
            return null;
        }
        Set<String> alreadyConnectedNodes = this.connectedNodes;
        alreadyConnectedNodes.removeAll(excludedNodes);
        String selectedNodeName = this.clusterNodeSelector.selectNode(this.clusterName, alreadyConnectedNodes.toArray(new String[alreadyConnectedNodes.size()]), availableNodes.toArray(new String[availableNodes.size()]));
        if (selectedNodeName == null || selectedNodeName.trim().isEmpty()) {
            logger.warn(this.clusterNodeSelector + " selected an invalid node name: " + selectedNodeName + " for cluster: " + this.clusterName + ". No EJB receiver context can be selected");
            return null;
        }
        logger.debug(this.clusterNodeSelector + " has selected node " + selectedNodeName + ", in cluster " + this.clusterName);
        excludedNodes.add(selectedNodeName);
        ClusterNodeManager clusterNodeManager = this.nodeManagers.get(selectedNodeName);
        if (clusterNodeManager == null) {
            logger.debug("No node manager available for node: " + selectedNodeName + " in cluster: " + this.clusterName);
            if (availableNodes.contains(selectedNodeName) || alreadyConnectedNodes.contains(selectedNodeName)) {
                Set<String> nodesInThisCluster2 = this.nodeManagers.keySet();
                if (excludedNodes.containsAll(nodesInThisCluster2)) {
                    logger.debug("All nodes have been tried for a receiver, in cluster " + this.clusterName + ". No suitable receiver found");
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Retrying receiver selection in cluster " + this.clusterName + " with excluded nodes " + Arrays.toString(excludedNodes.toArray()));
                }
                return this.getEJBReceiverContext(invocationContext, excludedNodes);
            }
            logger.debug("Node selector returned a non-existent " + selectedNodeName + " for cluster: " + this.clusterName + ". No EJB receiver context can be selected");
            return null;
        }
        EJBReceiverContext selectedNodeReceiverContext = this.clientContext.getNodeEJBReceiverContext(selectedNodeName);
        if (selectedNodeReceiverContext != null) {
            if (selectedNodeReceiverContext.getReceiver().acceptsModule(ejbLocator.getAppName(), ejbLocator.getModuleName(), ejbLocator.getDistinctName())) {
                return selectedNodeReceiverContext;
            }
            logger.debug("Ignoring node " + selectedNodeName + " since it cannot handle appName=" + ejbLocator.getAppName() + ",moduleName=" + ejbLocator.getModuleName() + ",distinct-name=" + ejbLocator.getDistinctName());
        }
        if ((ejbReceiver = clusterNodeManager.getEJBReceiver()) != null) {
            this.registerEJBReceiver(ejbReceiver);
            EJBReceiverContext ejbReceiverContext = this.clientContext.getNodeEJBReceiverContext(selectedNodeName);
            if (ejbReceiverContext != null) {
                if (ejbReceiverContext.getReceiver().acceptsModule(ejbLocator.getAppName(), ejbLocator.getModuleName(), ejbLocator.getDistinctName())) {
                    return ejbReceiverContext;
                }
                logger.debug("Ignoring node " + selectedNodeName + " since it cannot handle appName=" + ejbLocator.getAppName() + ",moduleName=" + ejbLocator.getModuleName() + ",distinct-name=" + ejbLocator.getDistinctName());
            }
        }
        if (excludedNodes.containsAll(nodesInThisCluster = this.nodeManagers.keySet())) {
            logger.debug("All nodes have been tried for a receiver, in cluster " + this.clusterName + ". No suitable receiver found");
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Retrying receiver selection in cluster " + this.clusterName + " with excluded nodes " + Arrays.toString(excludedNodes.toArray()));
        }
        return this.getEJBReceiverContext(invocationContext, excludedNodes);
    }

    boolean isNodeAvailable(String nodeName) {
        if (nodeName == null) {
            return false;
        }
        return this.nodeManagers.containsKey(nodeName);
    }

    public void addClusterNode(String nodeName, ClusterNodeManager clusterNodeManager) {
        this.addClusterNodes(clusterNodeManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClusterNodes(ClusterNodeManager ... clusterNodeManagers) {
        if (clusterNodeManagers == null) {
            return;
        }
        try {
            HashSet<Future<Void>> futureAssociationResults = new HashSet<Future<Void>>();
            for (int i = 0; i < clusterNodeManagers.length; ++i) {
                ClusterNodeManager clusterNodeManager = clusterNodeManagers[i];
                if (clusterNodeManager == null) continue;
                String nodeName = clusterNodeManager.getNodeName();
                if (nodeName == null || nodeName.trim().isEmpty()) {
                    throw Logs.MAIN.nodeNameCannotBeNullOrEmptyStringForCluster(this.clusterName);
                }
                if (this.nodeManagers.containsKey(nodeName)) continue;
                this.nodeManagers.put(nodeName, clusterNodeManager);
                if (this.connectedNodes.contains(nodeName) || (long)this.connectedNodes.size() >= this.maxClusterNodeOpenConnections) continue;
                futureAssociationResults.add(executorService.submit(new EJBReceiverAssociationTask(this, nodeName)));
            }
            for (Future future : futureAssociationResults) {
                try {
                    future.get(5L, TimeUnit.SECONDS);
                }
                catch (Exception e) {}
            }
        }
        finally {
            for (ClusterContextListener listener : this.clusterContextListeners) {
                try {
                    listener.clusterNodesAdded(this.clusterName, clusterNodeManagers);
                }
                catch (Throwable throwable) {
                    logger.debug((Object)("Ignoring the exception thrown by listener " + listener), throwable);
                }
            }
        }
    }

    public void removeClusterNode(String nodeName) {
        this.nodeManagers.remove(nodeName);
        this.connectedNodes.remove(nodeName);
    }

    public void removeAllClusterNodes() {
        this.nodeManagers.clear();
        this.connectedNodes.clear();
    }

    void close() {
        this.removeAllClusterNodes();
    }

    public void registerEJBReceiver(EJBReceiver receiver) {
        if (receiver == null) {
            throw Logs.MAIN.paramCannotBeNull("EJB receiver");
        }
        String nodeName = receiver.getNodeName();
        if (this.connectedNodes.contains(nodeName)) {
            return;
        }
        this.clientContext.registerEJBReceiver(receiver, this);
        EJBReceiverContext ejbReceiverContext = this.clientContext.getNodeEJBReceiverContext(nodeName);
        if (ejbReceiverContext != null) {
            this.connectedNodes.add(nodeName);
            logger.debug(this + " Added a new EJB receiver in cluster context " + this.clusterName + " for node " + nodeName + ". Total nodes in cluster context = " + this.connectedNodes.size());
        }
    }

    private void setupClusterSpecificConfigurations(EJBClientConfiguration.ClusterConfiguration clusterConfiguration) {
        ClusterNodeSelector nodeSelector;
        long maxLimit = clusterConfiguration.getMaximumAllowedConnectedNodes();
        if (maxLimit > 0L) {
            this.maxClusterNodeOpenConnections = maxLimit;
        }
        if ((nodeSelector = clusterConfiguration.getClusterNodeSelector()) != null) {
            this.clusterNodeSelector = nodeSelector;
        }
    }

    @Override
    public void receiverContextClosed(EJBReceiverContext receiverContext) {
        String nodeName = receiverContext.getReceiver().getNodeName();
        this.connectedNodes.remove(nodeName);
        logger.debug("Node " + nodeName + " removed from cluster context " + this + " for cluster " + this.clusterName);
    }

    void registerListener(ClusterContextListener listener) {
        if (listener == null) {
            return;
        }
        this.clusterContextListeners.add(listener);
    }

    boolean unregisterListener(ClusterContextListener listener) {
        return this.clusterContextListeners.remove(listener);
    }

    static interface ClusterContextListener {
        public void clusterNodesAdded(String var1, ClusterNodeManager ... var2);
    }

    private class EJBReceiverAssociationTask
    implements Callable<Void> {
        private final ClusterContext clusterContext;
        private final String nodeName;

        EJBReceiverAssociationTask(ClusterContext clusterContext2, String nodeName) {
            this.nodeName = nodeName;
            this.clusterContext = clusterContext2;
        }

        @Override
        public Void call() throws Exception {
            ClusterNodeManager clusterNodeManager = (ClusterNodeManager)this.clusterContext.nodeManagers.get(this.nodeName);
            if (clusterNodeManager == null) {
                logger.debugf("Cannot create EJBReceiver since no cluster node manager found for node %s in cluster context for cluster %s", (Object)this.nodeName, (Object)ClusterContext.this.clusterName);
                return null;
            }
            EJBReceiver ejbReceiver = clusterNodeManager.getEJBReceiver();
            if (ejbReceiver == null) {
                return null;
            }
            this.clusterContext.registerEJBReceiver(ejbReceiver);
            return null;
        }
    }
}

