/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fr;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.KeywordMarkerFilter;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.fr.ElisionFilter;
import org.apache.lucene.analysis.fr.FrenchLightStemFilter;
import org.apache.lucene.analysis.fr.FrenchStemFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;
import org.tartarus.snowball.ext.FrenchStemmer;

public final class FrenchAnalyzer
extends StopwordAnalyzerBase {
    @Deprecated
    public static final String[] FRENCH_STOP_WORDS = new String[]{"a", "afin", "ai", "ainsi", "apr\u00e8s", "attendu", "au", "aujourd", "auquel", "aussi", "autre", "autres", "aux", "auxquelles", "auxquels", "avait", "avant", "avec", "avoir", "c", "car", "ce", "ceci", "cela", "celle", "celles", "celui", "cependant", "certain", "certaine", "certaines", "certains", "ces", "cet", "cette", "ceux", "chez", "ci", "combien", "comme", "comment", "concernant", "contre", "d", "dans", "de", "debout", "dedans", "dehors", "del\u00e0", "depuis", "derri\u00e8re", "des", "d\u00e9sormais", "desquelles", "desquels", "dessous", "dessus", "devant", "devers", "devra", "divers", "diverse", "diverses", "doit", "donc", "dont", "du", "duquel", "durant", "d\u00e8s", "elle", "elles", "en", "entre", "environ", "est", "et", "etc", "etre", "eu", "eux", "except\u00e9", "hormis", "hors", "h\u00e9las", "hui", "il", "ils", "j", "je", "jusqu", "jusque", "l", "la", "laquelle", "le", "lequel", "les", "lesquelles", "lesquels", "leur", "leurs", "lorsque", "lui", "l\u00e0", "ma", "mais", "malgr\u00e9", "me", "merci", "mes", "mien", "mienne", "miennes", "miens", "moi", "moins", "mon", "moyennant", "m\u00eame", "m\u00eames", "n", "ne", "ni", "non", "nos", "notre", "nous", "n\u00e9anmoins", "n\u00f4tre", "n\u00f4tres", "on", "ont", "ou", "outre", "o\u00f9", "par", "parmi", "partant", "pas", "pass\u00e9", "pendant", "plein", "plus", "plusieurs", "pour", "pourquoi", "proche", "pr\u00e8s", "puisque", "qu", "quand", "que", "quel", "quelle", "quelles", "quels", "qui", "quoi", "quoique", "revoici", "revoil\u00e0", "s", "sa", "sans", "sauf", "se", "selon", "seront", "ses", "si", "sien", "sienne", "siennes", "siens", "sinon", "soi", "soit", "son", "sont", "sous", "suivant", "sur", "ta", "te", "tes", "tien", "tienne", "tiennes", "tiens", "toi", "ton", "tous", "tout", "toute", "toutes", "tu", "un", "une", "va", "vers", "voici", "voil\u00e0", "vos", "votre", "vous", "vu", "v\u00f4tre", "v\u00f4tres", "y", "\u00e0", "\u00e7a", "\u00e8s", "\u00e9t\u00e9", "\u00eatre", "\u00f4"};
    public static final String DEFAULT_STOPWORD_FILE = "french_stop.txt";
    private Set<?> excltable = CharArraySet.EMPTY_SET;

    public static Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public FrenchAnalyzer(Version matchVersion) {
        this(matchVersion, matchVersion.onOrAfter(Version.LUCENE_31) ? DefaultSetHolder.DEFAULT_STOP_SET : DefaultSetHolder.DEFAULT_STOP_SET_30);
    }

    public FrenchAnalyzer(Version matchVersion, Set<?> stopwords) {
        this(matchVersion, stopwords, (Set<?>)CharArraySet.EMPTY_SET);
    }

    public FrenchAnalyzer(Version matchVersion, Set<?> stopwords, Set<?> stemExclutionSet) {
        super(matchVersion, stopwords);
        this.excltable = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy((Version)matchVersion, stemExclutionSet));
    }

    @Deprecated
    public FrenchAnalyzer(Version matchVersion, String ... stopwords) {
        this(matchVersion, StopFilter.makeStopSet((Version)matchVersion, (String[])stopwords));
    }

    @Deprecated
    public FrenchAnalyzer(Version matchVersion, File stopwords) throws IOException {
        this(matchVersion, (Set<?>)WordlistLoader.getWordSet((Reader)IOUtils.getDecodingReader((File)stopwords, (Charset)IOUtils.CHARSET_UTF_8), (Version)matchVersion));
    }

    @Deprecated
    public void setStemExclusionTable(String ... exclusionlist) {
        this.excltable = StopFilter.makeStopSet((Version)this.matchVersion, (String[])exclusionlist);
        this.setPreviousTokenStream(null);
    }

    @Deprecated
    public void setStemExclusionTable(Map<?, ?> exclusionlist) {
        this.excltable = new HashSet(exclusionlist.keySet());
        this.setPreviousTokenStream(null);
    }

    @Deprecated
    public void setStemExclusionTable(File exclusionlist) throws IOException {
        this.excltable = WordlistLoader.getWordSet((Reader)IOUtils.getDecodingReader((File)exclusionlist, (Charset)IOUtils.CHARSET_UTF_8), (Version)this.matchVersion);
        this.setPreviousTokenStream(null);
    }

    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        if (this.matchVersion.onOrAfter(Version.LUCENE_31)) {
            StandardTokenizer source = new StandardTokenizer(this.matchVersion, reader);
            Object result = new StandardFilter(this.matchVersion, (TokenStream)source);
            result = new ElisionFilter(this.matchVersion, (TokenStream)result);
            result = new LowerCaseFilter(this.matchVersion, (TokenStream)result);
            result = new StopFilter(this.matchVersion, (TokenStream)result, (Set)this.stopwords);
            if (!this.excltable.isEmpty()) {
                result = new KeywordMarkerFilter((TokenStream)result, this.excltable);
            }
            result = this.matchVersion.onOrAfter(Version.LUCENE_36) ? new FrenchLightStemFilter((TokenStream)result) : new SnowballFilter((TokenStream)result, new FrenchStemmer());
            return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
        }
        StandardTokenizer source = new StandardTokenizer(this.matchVersion, reader);
        Object result = new StandardFilter(this.matchVersion, (TokenStream)source);
        result = new StopFilter(this.matchVersion, (TokenStream)result, (Set)this.stopwords);
        if (!this.excltable.isEmpty()) {
            result = new KeywordMarkerFilter((TokenStream)result, this.excltable);
        }
        result = new FrenchStemFilter((TokenStream)result);
        return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)source, (TokenStream)new LowerCaseFilter(this.matchVersion, (TokenStream)result));
    }

    private static class DefaultSetHolder {
        @Deprecated
        static final Set<?> DEFAULT_STOP_SET_30 = CharArraySet.unmodifiableSet((CharArraySet)new CharArraySet(Version.LUCENE_CURRENT, Arrays.asList(FRENCH_STOP_WORDS), false));
        static final Set<?> DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getSnowballWordSet((Reader)IOUtils.getDecodingReader(SnowballFilter.class, (String)FrenchAnalyzer.DEFAULT_STOPWORD_FILE, (Charset)IOUtils.CHARSET_UTF_8), (Version)Version.LUCENE_CURRENT);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

