/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import java.io.IOException;
import java.io.StreamCorruptedException;
import org.apache.lucene.util.encoding.IntDecoder;

public class SimpleIntDecoder
extends IntDecoder {
    private byte[] buffer = new byte[4];

    @Override
    public long decode() throws IOException {
        int nRead;
        for (int offset = 0; offset < 4; offset += nRead) {
            nRead = this.in.read(this.buffer, offset, 4 - offset);
            if (nRead != -1) continue;
            if (offset > 0) {
                throw new StreamCorruptedException("Need 4 bytes for decoding an int, got only " + offset);
            }
            return 0x100000000L;
        }
        int v = this.buffer[3] & 0xFF;
        v |= this.buffer[2] << 8 & 0xFF00;
        v |= this.buffer[1] << 16 & 0xFF0000;
        return v |= this.buffer[0] << 24 & 0xFF000000;
    }

    public String toString() {
        return "Simple";
    }
}

