/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.example.simple;

import java.util.List;
import org.apache.lucene.facet.example.ExampleResult;
import org.apache.lucene.facet.example.ExampleUtils;
import org.apache.lucene.facet.example.simple.SimpleIndexer;
import org.apache.lucene.facet.example.simple.SimpleSearcher;
import org.apache.lucene.facet.search.results.FacetResult;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class SimpleMain {
    public static void main(String[] args) throws Exception {
        new SimpleMain().runSimple();
        new SimpleMain().runDrillDown().getFacetResults();
        ExampleUtils.log("DONE");
    }

    public ExampleResult runSimple() throws Exception {
        RAMDirectory indexDir = new RAMDirectory();
        RAMDirectory taxoDir = new RAMDirectory();
        ExampleUtils.log("index the sample documents...");
        SimpleIndexer.index((Directory)indexDir, (Directory)taxoDir);
        DirectoryTaxonomyReader taxo = new DirectoryTaxonomyReader((Directory)taxoDir);
        IndexReader indexReader = IndexReader.open((Directory)indexDir, (boolean)true);
        ExampleUtils.log("search the sample documents...");
        List<FacetResult> facetRes = SimpleSearcher.searchWithFacets(indexReader, taxo);
        taxo.close();
        indexReader.close();
        ExampleResult res = new ExampleResult();
        res.setFacetResults(facetRes);
        return res;
    }

    public ExampleResult runDrillDown() throws Exception {
        RAMDirectory indexDir = new RAMDirectory();
        RAMDirectory taxoDir = new RAMDirectory();
        ExampleUtils.log("index the sample documents...");
        SimpleIndexer.index((Directory)indexDir, (Directory)taxoDir);
        DirectoryTaxonomyReader taxo = new DirectoryTaxonomyReader((Directory)taxoDir);
        IndexReader indexReader = IndexReader.open((Directory)indexDir, (boolean)true);
        ExampleUtils.log("search the sample documents...");
        List<FacetResult> facetRes = SimpleSearcher.searchWithDrillDown(indexReader, taxo);
        taxo.close();
        indexReader.close();
        ExampleResult res = new ExampleResult();
        res.setFacetResults(facetRes);
        return res;
    }
}

