/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.CountDownLatch;
import javax.security.auth.Subject;
import org.jboss.as.controller.AccessAuditContext;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.remote.OperationAttachmentsProxy;
import org.jboss.as.controller.remote.OperationMessageHandlerProxy;
import org.jboss.as.controller.remote.ResponseAttachmentInputStreamSupport;
import org.jboss.as.controller.remote.SubjectProtocolUtil;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.ProtocolUtils;
import org.jboss.dmr.ModelNode;

public class TransactionalProtocolOperationHandler
implements ManagementRequestHandlerFactory {
    private final ModelController controller;
    private final ManagementChannelAssociation channelAssociation;
    private final ResponseAttachmentInputStreamSupport responseAttachmentSupport;

    public TransactionalProtocolOperationHandler(ModelController controller, ManagementChannelAssociation channelAssociation, ResponseAttachmentInputStreamSupport responseAttachmentSupport) {
        this.controller = controller;
        this.channelAssociation = channelAssociation;
        this.responseAttachmentSupport = responseAttachmentSupport;
    }

    public ManagementRequestHandler<?, ?> resolveHandler(ManagementRequestHandlerFactory.RequestHandlerChain handlers, ManagementRequestHeader request) {
        switch (request.getOperationId()) {
            case 71: {
                ExecuteRequestContext executeRequestContext = new ExecuteRequestContext(this.responseAttachmentSupport);
                try {
                    executeRequestContext.operation = handlers.registerActiveOperation(Integer.valueOf(request.getBatchId()), (Object)executeRequestContext, (ActiveOperation.CompletedCallback)executeRequestContext);
                }
                catch (IllegalStateException ise) {
                    return new AbortOperationHandler(true);
                }
                return new ExecuteRequestHandler();
            }
            case 78: {
                ExecuteRequestContext executeRequestContext = new ExecuteRequestContext(this.responseAttachmentSupport);
                try {
                    executeRequestContext.operation = handlers.registerActiveOperation(Integer.valueOf(request.getBatchId()), (Object)executeRequestContext, (ActiveOperation.CompletedCallback)executeRequestContext);
                    return new AbortOperationHandler(false);
                }
                catch (IllegalStateException ise) {
                    return new CompleteTxOperationHandler();
                }
            }
            case 79: {
                handlers.registerActiveOperation(Integer.valueOf(request.getBatchId()), null);
                return this.responseAttachmentSupport.getReadHandler();
            }
            case 68: {
                handlers.registerActiveOperation(Integer.valueOf(request.getBatchId()), null);
                return this.responseAttachmentSupport.getCloseHandler();
            }
        }
        return handlers.resolveNext();
    }

    protected OperationResponse internalExecute(Operation operation, ManagementRequestContext<?> context, OperationMessageHandler messageHandler, ProxyController.ProxyOperationControl control) {
        return this.controller.execute(operation, messageHandler, control);
    }

    static void sendResponse(ManagementRequestContext<ExecuteRequestContext> context, final byte responseType, final ModelNode response) throws IOException {
        final CountDownLatch latch = new CountDownLatch(1);
        final IOExceptionHolder exceptionHolder = new IOExceptionHolder();
        context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<ExecuteRequestContext>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(ManagementRequestContext<ExecuteRequestContext> context) throws Exception {
                FlushableDataOutput output = null;
                try {
                    ControllerLogger.MGMT_OP_LOGGER.tracef("Transmitting response for %d", context.getOperationId());
                    ManagementResponseHeader header = ManagementResponseHeader.create((ManagementProtocolHeader)context.getRequestHeader());
                    output = context.writeMessage((ManagementProtocolHeader)header);
                    output.writeByte((int)responseType);
                    response.writeExternal((DataOutput)output);
                    output.writeByte(36);
                    output.close();
                    StreamUtils.safeClose((Closeable)output);
                    latch.countDown();
                }
                catch (IOException toCache) {
                    exceptionHolder.exception = toCache;
                }
                finally {
                    StreamUtils.safeClose(output);
                    latch.countDown();
                }
            }
        }, false);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (exceptionHolder.exception != null) {
            throw exceptionHolder.exception;
        }
    }

    static Subject readSubject(DataInput input) throws IOException {
        return SubjectProtocolUtil.read(input);
    }

    private static class IOExceptionHolder {
        private IOException exception;

        private IOExceptionHolder() {
        }
    }

    static class ExecuteRequestContext
    implements ActiveOperation.CompletedCallback<Void> {
        private boolean prepared;
        private boolean rollbackOnPrepare;
        private ModelController.OperationTransaction activeTx;
        private ActiveOperation<Void, ExecuteRequestContext> operation;
        private ManagementRequestContext<ExecuteRequestContext> responseChannel;
        private final CountDownLatch txCompletedLatch = new CountDownLatch(1);
        private boolean txCompleted;
        private PrivilegedAction<Void> action;
        final ResponseAttachmentInputStreamSupport streamSupport;

        ExecuteRequestContext(ResponseAttachmentInputStreamSupport streamSupport) {
            this.streamSupport = streamSupport;
        }

        Integer getOperationId() {
            return this.operation.getOperationId();
        }

        ActiveOperation.ResultHandler<Void> getResultHandler() {
            return this.operation.getResultHandler();
        }

        public PrivilegedAction<Void> getAction() {
            return this.action;
        }

        public void setAction(PrivilegedAction<Void> action) {
            this.action = action;
        }

        public void completed(Void result) {
        }

        public synchronized void failed(Exception e) {
            if (this.prepared) {
                ModelController.OperationTransaction transaction = this.activeTx;
                if (transaction != null) {
                    transaction.rollback();
                    this.txCompletedLatch.countDown();
                }
            } else if (this.responseChannel != null) {
                this.rollbackOnPrepare = true;
                String message = e.getMessage() != null ? e.getMessage() : "failure before rollback " + e.getClass().getName();
                ModelNode response = new ModelNode();
                response.get("outcome").set("failed");
                response.get("failure-description").set(message);
                ControllerLogger.MGMT_OP_LOGGER.tracef("sending pre-prepare failed response for %d  --- interrupted: %s", this.getOperationId(), Thread.currentThread().isInterrupted());
                try {
                    TransactionalProtocolOperationHandler.sendResponse(this.responseChannel, (byte)73, response);
                }
                catch (IOException ignored) {
                    ControllerLogger.MGMT_OP_LOGGER.debugf(ignored, "failed to process message", new Object[0]);
                }
            }
        }

        public void cancelled() {
        }

        synchronized void initialize(ManagementRequestContext<ExecuteRequestContext> context) {
            assert (!this.prepared);
            assert (this.activeTx == null);
            this.responseChannel = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void prepare(ModelController.OperationTransaction tx, ModelNode result) {
            if (this.rollbackOnPrepare) {
                try {
                    tx.rollback();
                }
                finally {
                    this.txCompletedLatch.countDown();
                }
            }
            assert (!this.prepared);
            assert (this.activeTx == null);
            assert (this.responseChannel != null);
            ControllerLogger.MGMT_OP_LOGGER.tracef("sending prepared response for %d  --- interrupted: %s", this.getOperationId(), Thread.currentThread().isInterrupted());
            try {
                TransactionalProtocolOperationHandler.sendResponse(this.responseChannel, (byte)75, result);
                this.activeTx = tx;
                this.prepared = true;
            }
            catch (IOException e) {
                this.getResultHandler().failed((Exception)e);
            }
            finally {
                this.responseChannel = null;
            }
        }

        synchronized void completeTx(ManagementRequestContext<ExecuteRequestContext> context, boolean commit) {
            if (!this.prepared) {
                assert (!commit);
                ControllerLogger.MGMT_OP_LOGGER.tracef("completeTx (cancel unprepared) for %d", this.getOperationId());
                this.rollbackOnPrepare = true;
                this.cancel(context);
            } else if (this.txCompleted) {
                assert (!commit);
                ControllerLogger.MGMT_OP_LOGGER.tracef("completeTx (post-commit cancel) for %d", this.getOperationId());
                this.cancel(context);
            } else {
                assert (this.activeTx != null);
                assert (this.responseChannel == null);
                this.responseChannel = context;
                ControllerLogger.MGMT_OP_LOGGER.tracef("completeTx (%s) for %d", commit, this.getOperationId());
                if (commit) {
                    this.activeTx.commit();
                } else {
                    this.activeTx.rollback();
                }
                this.txCompleted = true;
                this.txCompletedLatch.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void failed(ModelNode response) {
            if (this.prepared) {
                this.completed(OperationResponse.Factory.createSimple((ModelNode)response));
            } else {
                assert (this.responseChannel != null);
                ControllerLogger.MGMT_OP_LOGGER.tracef("sending pre-prepare failed response for %d  --- interrupted: %s", this.getOperationId(), Thread.currentThread().isInterrupted());
                try {
                    TransactionalProtocolOperationHandler.sendResponse(this.responseChannel, (byte)73, response);
                }
                catch (IOException e) {
                    ControllerLogger.MGMT_OP_LOGGER.debugf(e, "failed to process message", new Object[0]);
                }
                finally {
                    this.getResultHandler().done(null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void completed(OperationResponse response) {
            assert (this.prepared);
            assert (this.responseChannel != null);
            ControllerLogger.MGMT_OP_LOGGER.tracef("sending completed response for %d  --- interrupted: %s", this.getOperationId(), Thread.currentThread().isInterrupted());
            this.streamSupport.registerStreams(this.operation.getOperationId(), response.getInputStreams());
            try {
                TransactionalProtocolOperationHandler.sendResponse(this.responseChannel, (byte)74, response.getResponseNode());
            }
            catch (IOException e) {
                ControllerLogger.MGMT_OP_LOGGER.debugf(e, "failed to process message", new Object[0]);
            }
            finally {
                this.getResultHandler().done(null);
            }
        }

        private void cancel(ManagementRequestContext<ExecuteRequestContext> context) {
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<ExecuteRequestContext>(){

                public void execute(ManagementRequestContext<ExecuteRequestContext> executeRequestContextManagementRequestContext) throws Exception {
                    ExecuteRequestContext.this.operation.getResultHandler().cancel();
                }
            }, false);
        }
    }

    static class ProxyOperationControlProxy
    implements ProxyController.ProxyOperationControl {
        private final ExecuteRequestContext requestContext;

        ProxyOperationControlProxy(ExecuteRequestContext requestContext) {
            this.requestContext = requestContext;
        }

        @Override
        public void operationFailed(ModelNode response) {
            this.requestContext.failed(response);
        }

        @Override
        public void operationCompleted(OperationResponse response) {
            this.requestContext.completed(response);
        }

        @Override
        public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
            this.requestContext.prepare(transaction, result);
            try {
                this.requestContext.txCompletedLatch.await();
            }
            catch (InterruptedException e) {
                ControllerLogger.ROOT_LOGGER.tracef("Clearing interrupted status from client request %d", this.requestContext.getOperationId());
                Thread.currentThread().interrupt();
            }
        }
    }

    private class AbortOperationHandler
    implements ManagementRequestHandler<Void, ExecuteRequestContext> {
        private final boolean forExecuteTxRequest;

        private AbortOperationHandler(boolean forExecuteTxRequest) {
            this.forExecuteTxRequest = forExecuteTxRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            if (this.forExecuteTxRequest) {
                try {
                    ExecutableRequest.parse(input, TransactionalProtocolOperationHandler.this.channelAssociation);
                }
                finally {
                    ControllerLogger.MGMT_OP_LOGGER.tracef("aborting (cancel received before request) for %d", context.getOperationId());
                    ModelNode response = new ModelNode();
                    response.get("outcome").set("cancelled");
                    ((ExecuteRequestContext)context.getAttachment()).failed(response);
                }
            } else {
                byte commitOrRollback = input.readByte();
                if (commitOrRollback == 112) {
                    throw ControllerMessages.MESSAGES.responseHandlerNotFound(context.getOperationId());
                }
            }
        }
    }

    private class CompleteTxOperationHandler
    implements ManagementRequestHandler<Void, ExecuteRequestContext> {
        private CompleteTxOperationHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ExecuteRequestContext executeRequestContext = (ExecuteRequestContext)context.getAttachment();
            byte commitOrRollback = input.readByte();
            executeRequestContext.completeTx(context, commitOrRollback == 112);
        }
    }

    private static class ExecutableRequest {
        private final ModelNode operation;
        private final int attachmentsLength;
        private final Subject subject;

        private ExecutableRequest(ModelNode operation, int attachmentsLength, Subject subject) {
            this.operation = operation;
            this.attachmentsLength = attachmentsLength;
            this.subject = subject;
        }

        static ExecutableRequest parse(DataInput input, ManagementChannelAssociation channelAssociation) throws IOException {
            ModelNode operation = new ModelNode();
            ProtocolUtils.expectHeader((DataInput)input, (int)97);
            operation.readExternal(input);
            ProtocolUtils.expectHeader((DataInput)input, (int)101);
            int attachmentsLength = input.readInt();
            Boolean readSubject = (Boolean)channelAssociation.getAttachments().getAttachment(TransactionalProtocolClient.SEND_SUBJECT);
            Subject subject = readSubject != null && readSubject != false ? TransactionalProtocolOperationHandler.readSubject(input) : new Subject();
            return new ExecutableRequest(operation, attachmentsLength, subject);
        }
    }

    private class ExecuteRequestHandler
    implements ManagementRequestHandler<Void, ExecuteRequestContext> {
        private ExecuteRequestHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, final ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ControllerLogger.MGMT_OP_LOGGER.tracef("Handling transactional ExecuteRequest for %d", context.getOperationId());
            final ExecutableRequest executableRequest = ExecutableRequest.parse(input, TransactionalProtocolOperationHandler.this.channelAssociation);
            final PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ExecuteRequestHandler.this.doExecute(executableRequest.operation, executableRequest.attachmentsLength, (ManagementRequestContext<ExecuteRequestContext>)context);
                    return null;
                }
            };
            ExecuteRequestContext executeRequestContext = (ExecuteRequestContext)context.getAttachment();
            executeRequestContext.initialize(context);
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<ExecuteRequestContext>(){

                public void execute(ManagementRequestContext<ExecuteRequestContext> context) throws Exception {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            AccessAuditContext.doAs(executableRequest.subject, action);
                            return null;
                        }
                    });
                }
            });
        }

        protected void doExecute(ModelNode operation, int attachmentsLength, ManagementRequestContext<ExecuteRequestContext> context) {
            OperationResponse result;
            ControllerLogger.MGMT_OP_LOGGER.tracef("Executing transactional ExecuteRequest for %d", context.getOperationId());
            ExecuteRequestContext executeRequestContext = (ExecuteRequestContext)context.getAttachment();
            executeRequestContext.initialize(context);
            Integer batchId = executeRequestContext.getOperationId();
            OperationMessageHandlerProxy messageHandlerProxy = new OperationMessageHandlerProxy(TransactionalProtocolOperationHandler.this.channelAssociation, batchId);
            ProxyOperationControlProxy control = new ProxyOperationControlProxy(executeRequestContext);
            OperationAttachmentsProxy attachmentsProxy = OperationAttachmentsProxy.create(operation, TransactionalProtocolOperationHandler.this.channelAssociation, batchId, attachmentsLength);
            try {
                result = TransactionalProtocolOperationHandler.this.internalExecute(attachmentsProxy, context, messageHandlerProxy, control);
            }
            catch (Exception e) {
                ModelNode failure = new ModelNode();
                failure.get("outcome").set("failed");
                failure.get("failure-description").set(e.getClass().getName() + ":" + e.getMessage());
                control.operationFailed(failure);
                attachmentsProxy.shutdown(e);
                return;
            }
            if (result.getResponseNode().hasDefined("failure-description")) {
                control.operationFailed(result.getResponseNode());
            } else {
                control.operationCompleted(result);
            }
        }
    }
}

