/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions;

import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.access.management.AccessConstraintDescriptionProviderUtil;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;

public class DefaultResourceDescriptionProvider
implements DescriptionProvider {
    private final ImmutableManagementResourceRegistration registration;
    private final ResourceDescriptionResolver descriptionResolver;
    private final DeprecationData deprecationData;

    public DefaultResourceDescriptionProvider(ImmutableManagementResourceRegistration registration, ResourceDescriptionResolver descriptionResolver) {
        this(registration, descriptionResolver, null);
    }

    public DefaultResourceDescriptionProvider(ImmutableManagementResourceRegistration registration, ResourceDescriptionResolver descriptionResolver, DeprecationData deprecationData) {
        this.registration = registration;
        this.descriptionResolver = descriptionResolver;
        this.deprecationData = deprecationData;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        ModelNode result = new ModelNode();
        ResourceBundle bundle2 = this.descriptionResolver.getResourceBundle(locale);
        result.get("description").set(this.descriptionResolver.getResourceDescription(locale, bundle2));
        if (this.deprecationData != null) {
            ModelNode deprecated = this.addDeprecatedInfo(result);
            deprecated.get("reason").set(this.descriptionResolver.getResourceDeprecatedDescription(locale, bundle2));
        }
        AccessConstraintDescriptionProviderUtil.addAccessConstraints(result, this.registration.getAccessConstraints(), locale);
        ModelNode attributes = result.get("attributes").setEmptyObject();
        Set<String> attributeNames = this.registration.getAttributeNames(PathAddress.EMPTY_ADDRESS);
        for (String attr : attributeNames) {
            AttributeAccess attributeAccess = this.registration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attr);
            AttributeDefinition def = attributeAccess.getAttributeDefinition();
            if (def != null) {
                def.addResourceAttributeDescription(result, this.descriptionResolver, locale, bundle2);
                continue;
            }
            attributes.get(attr);
        }
        result.get("operations");
        result.get("notifications");
        ModelNode children = result.get("children").setEmptyObject();
        Set<PathElement> childAddresses = this.registration.getChildAddresses(PathAddress.EMPTY_ADDRESS);
        HashSet<String> childTypes = new HashSet<String>();
        for (PathElement childAddress : childAddresses) {
            String key = childAddress.getKey();
            if (!childTypes.add(key)) continue;
            ModelNode childNode = children.get(key);
            childNode.get("description").set(this.descriptionResolver.getChildTypeDescription(key, locale, bundle2));
            childNode.get("model-description");
        }
        return result;
    }

    private ModelNode addDeprecatedInfo(ModelNode model) {
        ModelNode deprecated = model.get("deprecated");
        deprecated.get("since").set(this.deprecationData.getSince().toString());
        deprecated.get("reason");
        return deprecated;
    }
}

