/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.tx;

import javax.ejb.EJBException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.tx.ApplicationExceptionDetails;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionTimeoutConfiguration;

public abstract class BMTInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(BMTInterceptor.class);
    private final EJBComponent component;

    public BMTInterceptor(EJBComponent component) {
        this.component = component;
    }

    protected abstract Object handleInvocation(InterceptorContext var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        Object object;
        Transaction oldTx;
        int oldTimeout;
        TransactionManager tm;
        block6: {
            tm = this.component.getTransactionManager();
            oldTimeout = this.getCurrentTransactionTimeout(this.component);
            oldTx = tm.suspend();
            object = this.handleInvocation(context);
            if (oldTx == null) break block6;
            tm.resume(oldTx);
        }
        tm.setTransactionTimeout(oldTimeout == -1 ? 0 : oldTimeout);
        return object;
        {
            catch (Throwable throwable) {
                try {
                    if (oldTx != null) {
                        tm.resume(oldTx);
                    }
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    tm.setTransactionTimeout(oldTimeout == -1 ? 0 : oldTimeout);
                    throw throwable2;
                }
            }
        }
    }

    protected Exception handleException(InterceptorContext invocation, Throwable ex) throws Exception {
        ApplicationExceptionDetails ae = this.component.getApplicationException(ex.getClass(), invocation.getMethod());
        if (ae != null) {
            throw (Exception)ex;
        }
        if (ex instanceof EJBException) {
            throw (EJBException)ex;
        }
        if (ex instanceof Exception) {
            throw new EJBException((Exception)ex);
        }
        throw new EJBException((Exception)new RuntimeException(ex));
    }

    protected int getCurrentTransactionTimeout(EJBComponent component) throws SystemException {
        TransactionManager tm = component.getTransactionManager();
        if (tm instanceof TransactionTimeoutConfiguration) {
            return ((TransactionTimeoutConfiguration)tm).getTransactionTimeout();
        }
        return 0;
    }

    public EJBComponent getComponent() {
        return this.component;
    }
}

