/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.ejb3.cache.impl.backing.clustering.ClusteredBackingCacheEntryStoreConfig;
import org.jboss.as.ejb3.cache.impl.backing.clustering.ClusteredBackingCacheEntryStoreSourceService;
import org.jboss.as.ejb3.subsystem.ClusterPassivationStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.PassivationStoreAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class ClusterPassivationStoreAdd
extends PassivationStoreAdd {
    public ClusterPassivationStoreAdd(AttributeDefinition ... attributes) {
        super(attributes);
    }

    @Override
    Collection<ServiceController<?>> installRuntimeServices(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        ClusteredBackingCacheEntryStoreSourceService service = new ClusteredBackingCacheEntryStoreSourceService(name);
        ClusteredBackingCacheEntryStoreConfig config = (ClusteredBackingCacheEntryStoreConfig)service.getValue();
        config.setCacheContainer(ClusterPassivationStoreResourceDefinition.CACHE_CONTAINER.resolveModelAttribute(context, model).asString());
        ModelNode beanCacheNode = ClusterPassivationStoreResourceDefinition.BEAN_CACHE.resolveModelAttribute(context, model);
        if (beanCacheNode.isDefined()) {
            config.setBeanCache(beanCacheNode.asString());
        }
        config.setClientMappingCache(ClusterPassivationStoreResourceDefinition.CLIENT_MAPPINGS_CACHE.resolveModelAttribute(context, model).asString());
        config.setPassivateEventsOnReplicate(ClusterPassivationStoreResourceDefinition.PASSIVATE_EVENTS_ON_REPLICATE.resolveModelAttribute(context, model).asBoolean());
        ServiceName serviceName = ClusteredBackingCacheEntryStoreSourceService.getPassivationStoreClusterNameServiceName(name);
        ServiceRegistry registry = context.getServiceRegistry(true);
        if (registry.getService(serviceName) != null) {
            context.removeService(serviceName);
        }
        InjectedValue clusterName = new InjectedValue();
        ServiceController controller = context.getServiceTarget().addService(serviceName, (Service)new ValueService((Value)clusterName)).addDependency(ClusteredBackingCacheEntryStoreSourceService.getCacheContainerClusterNameServiceName(config.getCacheContainer()), String.class, (Injector)clusterName).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        return Arrays.asList(this.installBackingCacheEntryStoreSourceService(service, context, model, verificationHandler), controller);
    }
}

