/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.tx.noopts;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.jca.core.spi.transaction.xa.XATerminator;
import org.jboss.jca.core.tx.noopts.TransactionImpl;
import org.jboss.jca.core.tx.noopts.TxRegistry;

public class TransactionManagerImpl
implements TransactionManager {
    private TxRegistry registry = null;
    private XATerminator terminator = null;

    public void setRegistry(TxRegistry v) {
        this.registry = v;
    }

    public XATerminator getXATerminator() {
        return this.terminator;
    }

    public void setXATerminator(XATerminator v) {
        this.terminator = v;
    }

    public void begin() throws NotSupportedException, SystemException {
        TransactionImpl tx = this.registry.getTransaction();
        if (tx != null) {
            throw new NotSupportedException();
        }
        this.registry.startTransaction();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionImpl tx = this.registry.getTransaction();
        if (tx == null) {
            throw new SystemException();
        }
        if (tx.getStatus() == 4 || tx.getStatus() == 1) {
            throw new RollbackException();
        }
        this.registry.endTransaction();
    }

    public int getStatus() throws SystemException {
        TransactionImpl tx = this.registry.getTransaction();
        if (tx == null) {
            return 6;
        }
        return tx.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.registry.getTransaction();
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (!(tobj instanceof TransactionImpl)) {
            throw new SystemException();
        }
        this.registry.assignTransaction((TransactionImpl)tobj);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        TransactionImpl tx = this.registry.getTransaction();
        if (tx == null) {
            throw new IllegalStateException();
        }
        this.registry.endTransaction();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        TransactionImpl tx = this.registry.getTransaction();
        if (tx == null) {
            throw new IllegalStateException();
        }
        tx.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
    }

    public Transaction suspend() throws SystemException {
        TransactionImpl tx = this.registry.getTransaction();
        this.registry.assignTransaction(null);
        return tx;
    }
}

