/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import org.jboss.as.jaxrs.deployment.JaxrsDeploymentMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class JaxrsDependencyProcessor
implements DeploymentUnitProcessor {
    public static final ModuleIdentifier RESTEASY_ATOM = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-atom-provider");
    public static final ModuleIdentifier RESTEASY_CDI = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-cdi");
    public static final ModuleIdentifier RESTEASY_HIBERNATE_VALIDATOR = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-hibernatevalidator-provider");
    public static final ModuleIdentifier RESTEASY_JAXRS = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-jaxrs");
    public static final ModuleIdentifier RESTEASY_JAXB = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-jaxb-provider");
    public static final ModuleIdentifier RESTEASY_JACKSON = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-jackson-provider");
    public static final ModuleIdentifier RESTEASY_JETTISON = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-jettison-provider");
    public static final ModuleIdentifier RESTEASY_JSAPI = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-jsapi");
    public static final ModuleIdentifier RESTEASY_MULTIPART = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-multipart-provider");
    public static final ModuleIdentifier RESTEASY_YAML = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-yaml-provider");
    public static final ModuleIdentifier JAXB_API = ModuleIdentifier.create((String)"javax.xml.bind.api");
    public static final ModuleIdentifier JAXRS_API = ModuleIdentifier.create((String)"javax.ws.rs.api");
    public static final ModuleIdentifier JACKSON_CORE_ASL = ModuleIdentifier.create((String)"org.codehaus.jackson.jackson-core-asl");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        this.addDependency(moduleSpecification, moduleLoader, JAXRS_API);
        this.addDependency(moduleSpecification, moduleLoader, JAXB_API);
        if (!JaxrsDeploymentMarker.isJaxrsDeployment(deploymentUnit)) {
            return;
        }
        this.addDependency(moduleSpecification, moduleLoader, RESTEASY_ATOM);
        this.addDependency(moduleSpecification, moduleLoader, RESTEASY_HIBERNATE_VALIDATOR);
        this.addDependency(moduleSpecification, moduleLoader, RESTEASY_JAXRS);
        this.addDependency(moduleSpecification, moduleLoader, RESTEASY_JAXB);
        this.addDependency(moduleSpecification, moduleLoader, RESTEASY_JACKSON);
        this.addDependency(moduleSpecification, moduleLoader, RESTEASY_JETTISON);
        this.addDependency(moduleSpecification, moduleLoader, RESTEASY_JSAPI);
        this.addDependency(moduleSpecification, moduleLoader, RESTEASY_MULTIPART);
        this.addDependency(moduleSpecification, moduleLoader, RESTEASY_YAML);
        this.addDependency(moduleSpecification, moduleLoader, JACKSON_CORE_ASL);
        if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            this.addDependency(moduleSpecification, moduleLoader, RESTEASY_CDI);
        }
    }

    private void addDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier) {
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, moduleIdentifier, false, false, true, false));
    }

    public void undeploy(DeploymentUnit context) {
    }
}

