/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.processor.LogUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessor;

class LogUpdateProcessor
extends UpdateRequestProcessor {
    private final SolrQueryRequest req;
    private final SolrQueryResponse rsp;
    private final NamedList<Object> toLog;
    int numAdds;
    int numDeletes;
    private List<String> adds;
    private List<String> deletes;
    private final int maxNumToLog;
    private final boolean logDebug;

    public LogUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, LogUpdateProcessorFactory factory, UpdateRequestProcessor next) {
        super(next);
        this.logDebug = this.log.isDebugEnabled();
        this.req = req;
        this.rsp = rsp;
        this.maxNumToLog = factory.maxNumToLog;
        this.toLog = new SimpleOrderedMap();
    }

    @Override
    public void processAdd(AddUpdateCommand cmd) throws IOException {
        if (this.adds == null) {
            this.adds = new ArrayList<String>();
            this.toLog.add("add", this.adds);
        }
        if (this.adds.size() < this.maxNumToLog) {
            this.adds.add(cmd.getPrintableId(this.req.getSchema()));
        }
        if (this.logDebug) {
            this.log.debug("add {}", (Object)cmd.getPrintableId(this.req.getSchema()));
        }
        ++this.numAdds;
        if (this.next != null) {
            this.next.processAdd(cmd);
        }
    }

    @Override
    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        if (cmd.id != null) {
            if (this.deletes == null) {
                this.deletes = new ArrayList<String>();
                this.toLog.add("delete", this.deletes);
            }
            if (this.deletes.size() < this.maxNumToLog) {
                this.deletes.add(cmd.id);
            }
            if (this.logDebug) {
                this.log.debug("delete {}", (Object)cmd.id);
            }
        } else {
            if (this.toLog.size() < this.maxNumToLog) {
                this.toLog.add("deleteByQuery", (Object)cmd.query);
            }
            if (this.logDebug) {
                this.log.debug("deleteByQuery {}", (Object)cmd.query);
            }
        }
        ++this.numDeletes;
        if (this.next != null) {
            this.next.processDelete(cmd);
        }
    }

    @Override
    public void processMergeIndexes(MergeIndexesCommand cmd) throws IOException {
        this.toLog.add("mergeIndexes", (Object)cmd.toString());
        if (this.logDebug) {
            this.log.debug("mergeIndexes {}", (Object)cmd.toString());
        }
        if (this.next != null) {
            this.next.processMergeIndexes(cmd);
        }
    }

    @Override
    public void processCommit(CommitUpdateCommand cmd) throws IOException {
        String msg = cmd.optimize ? "optimize" : "commit";
        this.toLog.add(msg, (Object)"");
        if (this.logDebug) {
            this.log.debug(msg);
        }
        if (this.next != null) {
            this.next.processCommit(cmd);
        }
    }

    @Override
    public void processRollback(RollbackUpdateCommand cmd) throws IOException {
        this.toLog.add("rollback", (Object)"");
        if (this.logDebug) {
            this.log.debug("rollback");
        }
        if (this.next != null) {
            this.next.processRollback(cmd);
        }
    }

    @Override
    public void finish() throws IOException {
        if (this.next != null) {
            this.next.finish();
        }
        if (this.adds != null && this.numAdds > this.maxNumToLog) {
            this.adds.add("... (" + this.numAdds + " adds)");
        }
        if (this.deletes != null && this.numDeletes > this.maxNumToLog) {
            this.deletes.add("... (" + this.numDeletes + " deletes)");
        }
        long elapsed = this.rsp.getEndTime() - this.req.getStartTime();
        this.log.info("" + this.toLog + " 0 " + elapsed);
    }
}

