/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.UpdateHandler;
import org.slf4j.Logger;

@Deprecated
public class DirectUpdateHandler
extends UpdateHandler {
    final HashSet<String> pset = new HashSet(256);
    IndexWriter writer;
    SolrIndexSearcher searcher;
    int numAdds = 0;
    int numPending = 0;
    int numDeleted = 0;

    public DirectUpdateHandler(SolrCore core) throws IOException {
        super(core);
    }

    protected void openWriter() throws IOException {
        if (this.writer == null) {
            this.writer = this.createMainIndexWriter("DirectUpdateHandler", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeWriter() throws IOException {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        finally {
            this.writer = null;
        }
    }

    protected void openSearcher() throws IOException {
        if (this.searcher == null) {
            this.searcher = this.core.newSearcher("DirectUpdateHandler");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSearcher() throws IOException {
        try {
            if (this.searcher != null) {
                this.searcher.close();
            }
        }
        finally {
            this.searcher = null;
        }
    }

    protected void doAdd(Document doc) throws IOException {
        this.closeSearcher();
        this.openWriter();
        this.writer.addDocument(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean existsInIndex(String indexedId) throws IOException {
        if (this.idField == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Operation requires schema to have a unique key field");
        }
        this.closeWriter();
        this.openSearcher();
        SolrIndexReader ir = this.searcher.getReader();
        TermDocs tdocs = null;
        boolean exists = false;
        try {
            tdocs = ir.termDocs(this.idTerm(indexedId));
            if (tdocs.next()) {
                exists = true;
            }
        }
        finally {
            try {
                if (tdocs != null) {
                    tdocs.close();
                }
            }
            catch (Exception e) {}
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int deleteInIndex(String indexedId) throws IOException {
        if (this.idField == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Operation requires schema to have a unique key field");
        }
        this.closeWriter();
        this.openSearcher();
        SolrIndexReader ir = this.searcher.getReader();
        Object tdocs = null;
        int num = 0;
        try {
            Term term = new Term(this.idField.getName(), indexedId);
            num = ir.deleteDocuments(term);
            if (SolrCore.log.isTraceEnabled()) {
                SolrCore.log.trace(this.core.getLogId() + "deleted " + num + " docs matching id " + this.idFieldType.indexedToReadable(indexedId));
            }
        }
        finally {
            try {
                if (tdocs != null) {
                    tdocs.close();
                }
            }
            catch (Exception e) {}
        }
        return num;
    }

    protected void overwrite(String indexedId, Document doc) throws IOException {
        if (indexedId == null) {
            indexedId = this.getIndexedId(doc);
        }
        this.deleteInIndex(indexedId);
        this.doAdd(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(DeleteUpdateCommand cmd) throws IOException {
        if (!cmd.fromPending && !cmd.fromCommitted) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "meaningless command: " + cmd);
        }
        if (!cmd.fromPending || !cmd.fromCommitted) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "operation not supported" + cmd);
        }
        String indexedId = this.idFieldType.toInternal(cmd.id);
        DirectUpdateHandler directUpdateHandler = this;
        synchronized (directUpdateHandler) {
            this.deleteInIndex(indexedId);
            this.pset.remove(indexedId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByQuery(DeleteUpdateCommand cmd) throws IOException {
        if (!cmd.fromPending && !cmd.fromCommitted) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "meaningless command: " + cmd);
        }
        if (!cmd.fromPending || !cmd.fromCommitted) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "operation not supported: " + cmd);
        }
        Query q = QueryParsing.parseQuery(cmd.query, this.schema);
        int totDeleted = 0;
        DirectUpdateHandler directUpdateHandler = this;
        synchronized (directUpdateHandler) {
            this.closeWriter();
            this.openSearcher();
            UpdateHandler.DeleteHitCollector deleter = new UpdateHandler.DeleteHitCollector(this.searcher);
            this.searcher.search(q, null, deleter);
            totDeleted = deleter.deleted;
        }
        if (SolrCore.log.isDebugEnabled()) {
            SolrCore.log.debug(this.core.getLogId() + "docs deleted:" + totDeleted);
        }
    }

    @Override
    public int mergeIndexes(MergeIndexesCommand cmd) throws IOException {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "DirectUpdateHandler doesn't support mergeIndexes. Use DirectUpdateHandler2 instead.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(CommitUpdateCommand cmd) throws IOException {
        Future[] waitSearcher = null;
        if (cmd.waitSearcher) {
            waitSearcher = new Future[1];
        }
        DirectUpdateHandler directUpdateHandler = this;
        synchronized (directUpdateHandler) {
            this.pset.clear();
            this.closeSearcher();
            if (cmd.optimize || cmd.expungeDeletes) {
                this.openWriter();
                if (cmd.optimize) {
                    this.writer.optimize(cmd.maxOptimizeSegments);
                }
                if (cmd.expungeDeletes) {
                    this.writer.expungeDeletes(cmd.expungeDeletes);
                }
            }
            this.closeWriter();
            this.callPostCommitCallbacks();
            if (cmd.optimize) {
                this.callPostOptimizeCallbacks();
            }
            this.core.getSearcher(true, false, waitSearcher);
        }
        if (waitSearcher != null && waitSearcher[0] != null) {
            try {
                waitSearcher[0].get();
            }
            catch (InterruptedException e) {
                SolrException.log((Logger)log, (Throwable)e);
            }
            catch (ExecutionException e) {
                SolrException.log((Logger)log, (Throwable)e);
            }
        }
    }

    @Override
    public void rollback(RollbackUpdateCommand cmd) throws IOException {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "DirectUpdateHandler doesn't support rollback. Use DirectUpdateHandler2 instead.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addNoOverwriteNoDups(AddUpdateCommand cmd) throws IOException {
        if (cmd.indexedId == null) {
            cmd.indexedId = this.getIndexedId(cmd.doc);
        }
        DirectUpdateHandler directUpdateHandler = this;
        synchronized (directUpdateHandler) {
            if (this.existsInIndex(cmd.indexedId)) {
                return 0;
            }
            this.doAdd(cmd.doc);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addConditionally(AddUpdateCommand cmd) throws IOException {
        if (cmd.indexedId == null) {
            cmd.indexedId = this.getIndexedId(cmd.doc);
        }
        DirectUpdateHandler directUpdateHandler = this;
        synchronized (directUpdateHandler) {
            if (this.pset.contains(cmd.indexedId)) {
                return 0;
            }
            this.pset.add(cmd.indexedId);
            this.overwrite(cmd.indexedId, cmd.doc);
            return 1;
        }
    }

    protected synchronized int overwriteBoth(AddUpdateCommand cmd) throws IOException {
        this.overwrite(cmd.indexedId, cmd.doc);
        return 1;
    }

    protected synchronized int allowDups(AddUpdateCommand cmd) throws IOException {
        this.doAdd(cmd.doc);
        return 1;
    }

    @Override
    public int addDoc(AddUpdateCommand cmd) throws IOException {
        if (this.idField == null) {
            cmd.allowDups = true;
            cmd.overwriteCommitted = false;
            cmd.overwritePending = false;
        }
        if (!(cmd.allowDups || cmd.overwritePending || cmd.overwriteCommitted)) {
            return this.addNoOverwriteNoDups(cmd);
        }
        if (!cmd.allowDups && !cmd.overwritePending && cmd.overwriteCommitted) {
            return this.addConditionally(cmd);
        }
        if (!cmd.allowDups && cmd.overwritePending && !cmd.overwriteCommitted) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unsupported param combo:" + cmd);
        }
        if (!cmd.allowDups && cmd.overwritePending && cmd.overwriteCommitted) {
            return this.overwriteBoth(cmd);
        }
        if (cmd.allowDups && !cmd.overwritePending && !cmd.overwriteCommitted) {
            return this.allowDups(cmd);
        }
        if (cmd.allowDups && !cmd.overwritePending && cmd.overwriteCommitted) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unsupported param combo:" + cmd);
        }
        if (cmd.allowDups && cmd.overwritePending && !cmd.overwriteCommitted) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unsupported param combo:" + cmd);
        }
        if (cmd.allowDups && cmd.overwritePending && cmd.overwriteCommitted) {
            return this.overwriteBoth(cmd);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unsupported param combo:" + cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        DirectUpdateHandler directUpdateHandler = this;
        synchronized (directUpdateHandler) {
            this.closeSearcher();
            this.closeWriter();
        }
    }

    @Override
    public String getName() {
        return DirectUpdateHandler.class.getName();
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public String getDescription() {
        return "Update handler that directly changes the on-disk main lucene index";
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.CORE;
    }

    @Override
    public String getSourceId() {
        return "$Id$";
    }

    @Override
    public String getSource() {
        return "$URL$";
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    @Override
    public NamedList getStatistics() {
        SimpleOrderedMap lst = new SimpleOrderedMap();
        return lst;
    }
}

