/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.solr.spelling.QueryConverter;

public class SpellingQueryConverter
extends QueryConverter {
    static final String[] NAMESTARTCHAR_PARTS = new String[]{"A-Z_a-z", "\\xc0-\\xd6", "\\xd8-\\xf6", "\\xf8-\\u02ff", "\\u0370-\\u037d", "\\u037f-\\u1fff", "\\u200c-\\u200d", "\\u2070-\\u218f", "\\u2c00-\\u2fef", "\\u2001-\\ud7ff", "\\uf900-\\ufdcf", "\\ufdf0-\\ufffd"};
    static final String[] ADDITIONAL_NAMECHAR_PARTS = new String[]{"\\-.0-9\\xb7", "\\u0300-\\u036f", "\\u203f-\\u2040"};
    static final String SURROGATE_PAIR = "\\p{Cs}{2}";
    static final String NMTOKEN;
    static final String PATTERN;
    protected Pattern QUERY_REGEX = Pattern.compile(PATTERN);

    @Override
    public Collection<Token> convert(String original) {
        if (original == null) {
            return Collections.emptyList();
        }
        ArrayList<Token> result = new ArrayList<Token>();
        Matcher matcher = this.QUERY_REGEX.matcher(original);
        while (matcher.find()) {
            String word = matcher.group(0);
            if (word.equals("AND") || word.equals("OR")) continue;
            try {
                this.analyze(result, new StringReader(word), matcher.start());
            }
            catch (IOException e) {}
        }
        return result;
    }

    protected void analyze(Collection<Token> result, Reader text, int offset) throws IOException {
        TokenStream stream = this.analyzer.reusableTokenStream("", text);
        CharTermAttribute termAtt = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
        FlagsAttribute flagsAtt = (FlagsAttribute)stream.addAttribute(FlagsAttribute.class);
        TypeAttribute typeAtt = (TypeAttribute)stream.addAttribute(TypeAttribute.class);
        PayloadAttribute payloadAtt = (PayloadAttribute)stream.addAttribute(PayloadAttribute.class);
        PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)stream.addAttribute(PositionIncrementAttribute.class);
        OffsetAttribute offsetAtt = (OffsetAttribute)stream.addAttribute(OffsetAttribute.class);
        stream.reset();
        while (stream.incrementToken()) {
            Token token = new Token();
            token.copyBuffer(termAtt.buffer(), 0, termAtt.length());
            token.setStartOffset(offset + offsetAtt.startOffset());
            token.setEndOffset(offset + offsetAtt.endOffset());
            token.setFlags(flagsAtt.getFlags());
            token.setType(typeAtt.type());
            token.setPayload(payloadAtt.getPayload());
            token.setPositionIncrement(posIncAtt.getPositionIncrement());
            result.add(token);
        }
        stream.end();
        stream.close();
    }

    static {
        StringBuilder sb = new StringBuilder();
        for (String part : NAMESTARTCHAR_PARTS) {
            sb.append(part);
        }
        for (String part : ADDITIONAL_NAMECHAR_PARTS) {
            sb.append(part);
        }
        NMTOKEN = "([" + sb.toString() + "]|" + SURROGATE_PAIR + ")+";
        PATTERN = "(?:(?!(" + NMTOKEN + ":|\\d+)))[\\p{L}_\\-0-9]+";
    }
}

