/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Searcher;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public class RangeMapFloatFunction
extends ValueSource {
    protected final ValueSource source;
    protected final float min;
    protected final float max;
    protected final float target;
    protected final Float defaultVal;

    public RangeMapFloatFunction(ValueSource source, float min, float max, float target, Float def) {
        this.source = source;
        this.min = min;
        this.max = max;
        this.target = target;
        this.defaultVal = def;
    }

    @Override
    public String description() {
        return "map(" + this.source.description() + "," + this.min + "," + this.max + "," + this.target + ")";
    }

    @Override
    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final DocValues vals = this.source.getValues(context, reader);
        return new DocValues(){

            @Override
            public float floatVal(int doc) {
                float val = vals.floatVal(doc);
                return val >= RangeMapFloatFunction.this.min && val <= RangeMapFloatFunction.this.max ? RangeMapFloatFunction.this.target : (RangeMapFloatFunction.this.defaultVal == null ? val : RangeMapFloatFunction.this.defaultVal.floatValue());
            }

            @Override
            public int intVal(int doc) {
                return (int)this.floatVal(doc);
            }

            @Override
            public long longVal(int doc) {
                return (long)this.floatVal(doc);
            }

            @Override
            public double doubleVal(int doc) {
                return this.floatVal(doc);
            }

            @Override
            public String strVal(int doc) {
                return Float.toString(this.floatVal(doc));
            }

            @Override
            public String toString(int doc) {
                return "map(" + vals.toString(doc) + ",min=" + RangeMapFloatFunction.this.min + ",max=" + RangeMapFloatFunction.this.max + ",target=" + RangeMapFloatFunction.this.target + ")";
            }
        };
    }

    @Override
    public void createWeight(Map context, Searcher searcher) throws IOException {
        this.source.createWeight(context, searcher);
    }

    @Override
    public int hashCode() {
        int h = this.source.hashCode();
        h ^= h << 10 | h >>> 23;
        h += Float.floatToIntBits(this.min);
        h ^= h << 14 | h >>> 19;
        h += Float.floatToIntBits(this.max);
        h ^= h << 13 | h >>> 20;
        h += Float.floatToIntBits(this.target);
        if (this.defaultVal != null) {
            h += this.defaultVal.hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (RangeMapFloatFunction.class != o.getClass()) {
            return false;
        }
        RangeMapFloatFunction other = (RangeMapFloatFunction)o;
        return this.min == other.min && this.max == other.max && this.target == other.target && this.source.equals(other.source) && (this.defaultVal == other.defaultVal || this.defaultVal != null && this.defaultVal.equals(other.defaultVal));
    }
}

