/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.search.WildcardGenerator;

public class WildcardFilter
extends Filter {
    protected final Term term;

    public WildcardFilter(Term wildcardTerm) {
        this.term = wildcardTerm;
    }

    public Term getTerm() {
        return this.term;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        final OpenBitSet bitSet = new OpenBitSet((long)reader.maxDoc());
        new WildcardGenerator(this.term){

            @Override
            public void handleDoc(int doc) {
                bitSet.set((long)doc);
            }
        }.generate(reader);
        return bitSet;
    }

    public boolean equals(Object o) {
        return o instanceof WildcardFilter && ((WildcardFilter)((Object)o)).term.equals((Object)this.term);
    }

    public int hashCode() {
        return this.term.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WildcardFilter(");
        sb.append(this.term.toString());
        sb.append(")");
        return sb.toString();
    }
}

