/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.FieldCacheSource;
import org.apache.solr.search.function.StringIndexDocValues;

class DateFieldSource
extends FieldCacheSource {
    FieldType ft;
    private static int hcode = DateFieldSource.class.hashCode();

    public DateFieldSource(String name, FieldType ft) {
        super(name);
        this.ft = ft;
    }

    @Override
    public String description() {
        return "date(" + this.field + ')';
    }

    @Override
    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        return new StringIndexDocValues(this, reader, this.field){

            @Override
            protected String toTerm(String readableValue) {
                return DateFieldSource.this.ft.toInternal(readableValue);
            }

            @Override
            public float floatVal(int doc) {
                return this.intVal(doc);
            }

            @Override
            public int intVal(int doc) {
                int ord = this.order[doc];
                return ord;
            }

            @Override
            public long longVal(int doc) {
                return this.intVal(doc);
            }

            @Override
            public double doubleVal(int doc) {
                return this.intVal(doc);
            }

            @Override
            public String strVal(int doc) {
                int ord = this.order[doc];
                return DateFieldSource.this.ft.indexedToReadable(this.lookup[ord]);
            }

            @Override
            public String toString(int doc) {
                return DateFieldSource.this.description() + '=' + this.intVal(doc);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof DateFieldSource && super.equals(o);
    }

    @Override
    public int hashCode() {
        return hcode + super.hashCode();
    }
}

