/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.util.Version;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.FSTSynonymFilterFactory;
import org.apache.solr.analysis.SlowSynonymFilterFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.util.plugin.ResourceLoaderAware;

public class SynonymFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private BaseTokenFilterFactory delegator;

    @Override
    public void init(Map<String, String> args) {
        super.init((Map)args);
        this.assureMatchVersion();
        if (this.luceneMatchVersion.onOrAfter(Version.LUCENE_34)) {
            this.delegator = new FSTSynonymFilterFactory();
        } else {
            if (args.containsKey("format") && !args.get("format").equals("solr")) {
                throw new IllegalArgumentException("You must specify luceneMatchVersion >= 3.4 to use alternate synonyms formats");
            }
            this.delegator = new SlowSynonymFilterFactory();
        }
        this.delegator.init((Map)args);
    }

    @Override
    public TokenStream create(TokenStream input) {
        assert (this.delegator != null) : "init() was not called!";
        return this.delegator.create(input);
    }

    @Override
    public void inform(ResourceLoader loader) {
        assert (this.delegator != null) : "init() was not called!";
        ((ResourceLoaderAware)((Object)this.delegator)).inform(loader);
    }
}

