/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.mapping;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Properties;
import javax.wsdl.WSDLException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.namespace.QName;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.AccessPointType;
import org.apache.juddi.v3.client.ClassUtil;
import org.apache.juddi.v3.client.config.Property;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.mapping.SelectionPolicy;
import org.apache.juddi.v3.client.mapping.Topology;
import org.apache.juddi.v3.client.mapping.UDDIServiceCache;
import org.apache.juddi.v3.client.mapping.URLLocalizer;
import org.apache.juddi.v3.client.transport.TransportException;
import org.uddi.api_v3.AccessPoint;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.Name;

public class ServiceLocator {
    private Log log = LogFactory.getLog(this.getClass());
    private String keyDomainURI;
    private UDDIClerk clerk;
    private Properties properties = new Properties();
    private UDDIServiceCache serviceCache = null;
    private SelectionPolicy selectionPolicy = null;

    public ServiceLocator(UDDIClerk clerk, URLLocalizer urlLocalizer, Properties properties) throws ClassNotFoundException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, DatatypeConfigurationException, MalformedURLException, RemoteException, ConfigurationException, WSDLException, TransportException {
        this.clerk = clerk;
        this.properties = properties;
        this.keyDomainURI = "uddi:" + properties.getProperty("keyDomain") + ":";
        this.serviceCache = new UDDIServiceCache(clerk, urlLocalizer, properties);
        String policy = properties.getProperty("juddi.client.selection.policy", "org.apache.juddi.v3.client.mapping.PolicyLocalFirst");
        Class<?> selectionPolicyClass = ClassUtil.forName(policy, this.getClass());
        this.selectionPolicy = (SelectionPolicy)selectionPolicyClass.getConstructor(Properties.class).newInstance(properties);
    }

    public void shutdown() throws RemoteException, ConfigurationException, TransportException {
        this.serviceCache.shutdown();
    }

    public void addService(String serviceKey) {
        Topology topology = this.lookupEndpointInUDDI(serviceKey);
        this.serviceCache.addService(serviceKey, topology);
    }

    public void removeService(String serviceKey) {
        this.serviceCache.removeService(serviceKey);
    }

    public String lookupEndpoint(QName serviceQName, String portName) {
        String epr = null;
        String serviceKey = Property.getServiceKey(this.properties, serviceQName);
        Topology topology = this.serviceCache.lookupService(serviceKey);
        if (topology == null) {
            topology = this.lookupEndpointInUDDI(serviceKey);
        }
        if (topology != null && topology.getEprs().size() > 0) {
            epr = this.selectionPolicy.select(topology);
        }
        return epr;
    }

    private Topology lookupEndpointInUDDI(String serviceKey) {
        Topology topology = null;
        try {
            BusinessService service = this.clerk.findService(serviceKey);
            if (service == null) {
                this.log.debug((Object)("No Service with key " + serviceKey + " was found in the registry."));
            }
            if (service != null && service.getBindingTemplates() != null && service.getBindingTemplates().getBindingTemplate() != null) {
                ArrayList<String> eprs = new ArrayList<String>();
                BindingTemplates bindingTemplates = service.getBindingTemplates();
                if (bindingTemplates == null) {
                    this.log.warn((Object)("Found service " + ((Name)service.getName().get(0)).getValue() + " with serviceKey '" + serviceKey + "'" + " but no EPRs"));
                } else {
                    this.log.debug((Object)("Found service " + ((Name)service.getName().get(0)).getValue() + " with serviceKey '" + serviceKey + "'" + " and " + bindingTemplates.getBindingTemplate().size() + " EPRs"));
                    for (BindingTemplate bindingTemplate : bindingTemplates.getBindingTemplate()) {
                        AccessPoint accessPoint = bindingTemplate.getAccessPoint();
                        if (!AccessPointType.END_POINT.toString().equals(accessPoint.getUseType())) continue;
                        String url = accessPoint.getValue();
                        this.log.debug((Object)("epr= " + url));
                        eprs.add(url);
                    }
                    if (eprs.size() > 0) {
                        topology = new Topology(eprs);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        return topology;
    }
}

