/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.UDecoder;
import org.jboss.web.CoyoteLogger;
import org.jboss.web.CoyoteMessages;

public final class Parameters {
    protected static final int MAX_COUNT = Integer.valueOf(System.getProperty("org.apache.tomcat.util.http.Parameters.MAX_COUNT", "512"));
    private final HashMap<String, ArrayList<String>> paramHashValues = new HashMap();
    private boolean didQueryParameters = false;
    MessageBytes queryMB;
    UDecoder urlDec;
    MessageBytes decodedQuery = MessageBytes.newInstance();
    String encoding = null;
    String queryStringEncoding = null;
    private int limit = MAX_COUNT;
    private int parameterCount = 0;
    private boolean parseFailed = false;
    ByteChunk tmpName = new ByteChunk();
    ByteChunk tmpValue = new ByteChunk();
    private final ByteChunk origName = new ByteChunk();
    private final ByteChunk origValue = new ByteChunk();
    CharChunk tmpNameC = new CharChunk(1024);
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");

    public void setQuery(MessageBytes queryMB) {
        this.queryMB = queryMB;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String s) {
        this.encoding = s;
    }

    public void setQueryStringEncoding(String s) {
        this.queryStringEncoding = s;
    }

    public boolean isParseFailed() {
        return this.parseFailed;
    }

    public void setParseFailed(boolean parseFailed) {
        this.parseFailed = parseFailed;
    }

    public void recycle() {
        this.parameterCount = 0;
        this.paramHashValues.clear();
        this.didQueryParameters = false;
        this.encoding = null;
        this.decodedQuery.recycle();
        this.parseFailed = false;
    }

    public void addParameterValues(String name, String[] values) {
        if (name == null || values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            this.addParameter(name, values[i]);
        }
    }

    public String[] getParameterValues(String name) {
        this.handleQueryParameters();
        ArrayList<String> values = this.paramHashValues.get(name);
        if (values == null) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    public Enumeration<String> getParameterNames() {
        this.handleQueryParameters();
        return Collections.enumeration(this.paramHashValues.keySet());
    }

    public String getParameter(String name) {
        this.handleQueryParameters();
        ArrayList<String> values = this.paramHashValues.get(name);
        if (values != null) {
            if (values.size() == 0) {
                return "";
            }
            return values.get(0);
        }
        return null;
    }

    public void handleQueryParameters() {
        if (this.didQueryParameters) {
            return;
        }
        this.didQueryParameters = true;
        if (this.queryMB == null || this.queryMB.isNull()) {
            return;
        }
        try {
            this.decodedQuery.duplicate(this.queryMB);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.processParameters(this.decodedQuery, this.queryStringEncoding);
    }

    public void addParameter(String key, String value) throws IllegalStateException {
        if (key == null) {
            return;
        }
        ++this.parameterCount;
        if (this.limit > -1 && this.parameterCount > this.limit) {
            this.parseFailed = true;
            throw CoyoteMessages.MESSAGES.maxParametersFail(this.limit);
        }
        ArrayList<String> values = this.paramHashValues.get(key);
        if (values == null) {
            values = new ArrayList(1);
            this.paramHashValues.put(key, values);
        }
        values.add(value);
    }

    public void setURLDecoder(UDecoder u) {
        this.urlDec = u;
    }

    public void processParameters(byte[] bytes, int start, int len) {
        this.processParameters(bytes, start, len, this.encoding);
    }

    private void processParameters(byte[] bytes, int start, int len, String enc) {
        if (CoyoteLogger.HTTP_LOGGER.isDebugEnabled()) {
            CoyoteLogger.HTTP_LOGGER.startProcessingParameter(new String(bytes, start, len, DEFAULT_CHARSET));
        }
        int decodeFailCount = 0;
        int pos = start;
        int end = start + len;
        while (pos < end) {
            block36: {
                int nameStart = pos;
                int nameEnd = -1;
                int valueStart = -1;
                int valueEnd = -1;
                boolean parsingName = true;
                boolean decodeName = false;
                boolean decodeValue = false;
                boolean parameterComplete = false;
                do {
                    switch (bytes[pos]) {
                        case 61: {
                            if (parsingName) {
                                nameEnd = pos++;
                                parsingName = false;
                                valueStart = pos;
                                break;
                            }
                            ++pos;
                            break;
                        }
                        case 38: {
                            if (parsingName) {
                                nameEnd = pos;
                            } else {
                                valueEnd = pos;
                            }
                            parameterComplete = true;
                            ++pos;
                            break;
                        }
                        case 37: 
                        case 43: {
                            if (parsingName) {
                                decodeName = true;
                            } else {
                                decodeValue = true;
                            }
                            ++pos;
                            break;
                        }
                        default: {
                            ++pos;
                        }
                    }
                } while (!parameterComplete && pos < end);
                if (pos == end) {
                    if (nameEnd == -1) {
                        nameEnd = pos;
                    } else if (valueStart > -1 && valueEnd == -1) {
                        valueEnd = pos;
                    }
                }
                if (CoyoteLogger.HTTP_LOGGER.isDebugEnabled() && valueStart == -1) {
                    CoyoteLogger.HTTP_LOGGER.parameterMissingEqual(nameStart, nameEnd, new String(bytes, nameStart, nameEnd - nameStart, DEFAULT_CHARSET));
                }
                if (nameEnd <= nameStart) {
                    if (valueStart == -1) {
                        if (!CoyoteLogger.HTTP_LOGGER.isDebugEnabled()) continue;
                        CoyoteLogger.HTTP_LOGGER.emptyParamterChunk();
                        continue;
                    }
                    if (CoyoteLogger.HTTP_LOGGER.isDebugEnabled()) {
                        String extract = valueEnd >= nameStart ? new String(bytes, nameStart, valueEnd - nameStart, DEFAULT_CHARSET) : "";
                        CoyoteLogger.HTTP_LOGGER.parameterInvalid(nameStart, valueEnd, extract);
                    }
                    this.parseFailed = true;
                    continue;
                }
                this.tmpName.setBytes(bytes, nameStart, nameEnd - nameStart);
                if (valueStart >= 0) {
                    this.tmpValue.setBytes(bytes, valueStart, valueEnd - valueStart);
                } else {
                    this.tmpValue.setBytes(bytes, 0, 0);
                }
                if (CoyoteLogger.HTTP_LOGGER.isDebugEnabled()) {
                    try {
                        this.origName.append(bytes, nameStart, nameEnd - nameStart);
                        if (valueStart >= 0) {
                            this.origValue.append(bytes, valueStart, valueEnd - valueStart);
                        } else {
                            this.origValue.append(bytes, 0, 0);
                        }
                    }
                    catch (IOException ioe) {
                        this.parseFailed = true;
                        CoyoteLogger.HTTP_LOGGER.parametersCopyFailed();
                    }
                }
                try {
                    String value;
                    if (decodeName) {
                        this.urlDecode(this.tmpName);
                    }
                    this.tmpName.setEncoding(enc);
                    String name = this.tmpName.toString();
                    if (valueStart >= 0) {
                        if (decodeValue) {
                            this.urlDecode(this.tmpValue);
                        }
                        this.tmpValue.setEncoding(enc);
                        value = this.tmpValue.toString();
                    } else {
                        value = "";
                    }
                    this.addParameter(name, value);
                }
                catch (IOException e) {
                    this.parseFailed = true;
                    ++decodeFailCount;
                    if (!CoyoteLogger.HTTP_LOGGER.isDebugEnabled()) break block36;
                    CoyoteLogger.HTTP_LOGGER.parameterDecodingFailed(this.origName.toString(), this.origValue.toString());
                }
            }
            this.tmpName.recycle();
            this.tmpValue.recycle();
            if (!CoyoteLogger.HTTP_LOGGER.isDebugEnabled()) continue;
            this.origName.recycle();
            this.origValue.recycle();
        }
        if (decodeFailCount > 1 && CoyoteLogger.HTTP_LOGGER.isDebugEnabled()) {
            CoyoteLogger.HTTP_LOGGER.parametersDecodingFailures(decodeFailCount);
        }
        if (this.parseFailed) {
            CoyoteLogger.HTTP_LOGGER.parametersProcessingFailed();
        }
    }

    private void urlDecode(ByteChunk bc) throws IOException {
        if (this.urlDec == null) {
            this.urlDec = new UDecoder();
        }
        this.urlDec.convert(bc, true);
    }

    public void processParameters(MessageBytes data, String encoding) {
        if (data == null || data.isNull() || data.getLength() <= 0) {
            return;
        }
        if (data.getType() != 2) {
            data.toBytes();
        }
        ByteChunk bc = data.getByteChunk();
        this.processParameters(bc.getBytes(), bc.getOffset(), bc.getLength(), encoding);
    }

    public String paramsAsString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ArrayList<String>> e : this.paramHashValues.entrySet()) {
            sb.append(e.getKey()).append('=');
            ArrayList<String> values = e.getValue();
            for (String value : values) {
                sb.append(value).append(',');
            }
            sb.append('\n');
        }
        return sb.toString();
    }
}

