/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.UAX29URLEmailTokenizer;
import org.apache.lucene.util.Version;

public final class UAX29URLEmailAnalyzer
extends StopwordAnalyzerBase {
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;
    public static final Set<?> STOP_WORDS_SET = StopAnalyzer.ENGLISH_STOP_WORDS_SET;

    public UAX29URLEmailAnalyzer(Version matchVersion, Set<?> stopWords) {
        super(matchVersion, stopWords);
    }

    public UAX29URLEmailAnalyzer(Version matchVersion) {
        this(matchVersion, STOP_WORDS_SET);
    }

    public UAX29URLEmailAnalyzer(Version matchVersion, Reader stopwords) throws IOException {
        this(matchVersion, WordlistLoader.getWordSet(stopwords, matchVersion));
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    @Override
    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        final UAX29URLEmailTokenizer src = new UAX29URLEmailTokenizer(this.matchVersion, reader);
        src.setMaxTokenLength(this.maxTokenLength);
        TokenFilter tok = new StandardFilter(this.matchVersion, src);
        tok = new LowerCaseFilter(this.matchVersion, tok);
        tok = new StopFilter(this.matchVersion, (TokenStream)tok, this.stopwords);
        return new ReusableAnalyzerBase.TokenStreamComponents(src, tok){

            @Override
            protected boolean reset(Reader reader) throws IOException {
                src.setMaxTokenLength(UAX29URLEmailAnalyzer.this.maxTokenLength);
                return super.reset(reader);
            }
        };
    }
}

